//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include "../src/MiX/DOM_Parser.h"
#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"

//CUPPA:namespace=+
//CUPPA:namespace=-

class DOM_ParserTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(DOM_ParserTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testParseBuffer);
  CPPUNIT_TEST(testParseStream);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
  static const char data_[];

public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void testParseBuffer() {
    MiX::DOM_Parser<char> parser;
    MiX::Document<char>& doc = parser.parse(data_);
    CPPUNIT_ASSERT(doc["version"].getValue()=="1.0");
    CPPUNIT_ASSERT(doc["encoding"].getValue()=="UTF-8");
    CPPUNIT_ASSERT(doc.getRoot().getName()=="TestSuite");
    CPPUNIT_ASSERT(doc.getRoot()["name"].getValue()=="DOM_ParserTest");
    CPPUNIT_ASSERT(doc.getRoot()("TestCase")["name"].getValue()=="testParse");
    CPPUNIT_ASSERT_EQUAL(MiX::XMLString<char>("This \nis \ntest \ntext."),
			 doc.getRoot().getText());
    CPPUNIT_ASSERT_EQUAL(MiX::XMLString<char>(data_),doc.toString());
  }
  void testParseStream() {
    std::istringstream ss(data_);
    /*MiX::Tokenizer<char> tokenizer;
    tokenizer.injectStream(ss);
    MiX::XMLToken<char> tok;
    do{
      tokenizer.ejectToken(tok);
      std::cout << "\"" << tok.getData() << "\", " << std::flush;
    }while(tok.getType()!=MiX::Token_null);
    */
    MiX::DOM_Parser<char> parser;
    MiX::Document<char>& doc = parser.parse(ss);
    CPPUNIT_ASSERT(doc["version"].getValue()=="1.0");
    CPPUNIT_ASSERT(doc["encoding"].getValue()=="UTF-8");
    CPPUNIT_ASSERT(doc.getRoot().getName()=="TestSuite");
    CPPUNIT_ASSERT(doc.getRoot()["name"].getValue()=="DOM_ParserTest");
    CPPUNIT_ASSERT(doc.getRoot()("TestCase")["name"].getValue()=="testParse");
    
    CPPUNIT_ASSERT_EQUAL(MiX::XMLString<char>("This \nis \ntest \ntext."),
			 doc.getRoot().getText());

    CPPUNIT_ASSERT_EQUAL(MiX::XMLString<char>(data_),doc.toString());
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

const char DOM_ParserTest::data_[] = {
  "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
  "<TestSuite name=\"DOM_ParserTest\">"
  "<!-- This is test comment. -->"
  "<TestCase name=\"testParse\"/>"
  "This \nis \ntest \ntext."
  "</TestSuite>"
};


CPPUNIT_TEST_SUITE_REGISTRATION(DOM_ParserTest);
