// -*- mode: c++ -*-

#ifndef MIX_SAXPARSER_H_
#define MIX_SAXPARSER_H_

#include <map>
#include <stack>

#include "classes.h"
#include "DefaultXMLTraits.h"
#include "misc.h"
#include "Tokenizer.h"
#include "SAX_EventHandler.h"
#include "XMLString.h"
#include "AttrMap.h"

namespace MiX{
  /**
   * ^ꂽ͂SAX_EventHandlerɓK؂ȃCxgNNX
   * TokenizergpĂ
   */
  template <class charT,class traitsT>
  class SAX_Parser{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef SAX_Parser<charT,traitsT> this_type;
    typedef XMLToken<charT,traitsT> token_type;
    typedef SAX_EventHandler<charT,traitsT> handler_type;
    typedef Tokenizer<charT,traitsT> tokenizer_type;
  private:
    enum State{
      STATE_Text,
      STATE_Tag,
      STATE_Reference,
      STATE_Comment,
      STATE_Complete,
      STATE_Declaration,
      STATE_XMLDeclaration,
      STATE_Escape,
      STATE_Exception
    };
    State state_;
    tokenizer_type tokenizer_;
    handler_type* handler_;
    std::stack<string_type> validator_;

    bool ignore_space_;

    void skipSpaceTokens();

    bool parsingLoop();

    State parseText();
    State parseTag();
    State parseComment();
    State parseDeclaration();
    State parseXMLDeclaration();

    attrmap_type parseAttributes();
    string_type parseReference();

    void trimRight(string_type& str);
  public:
    ///RXgN^
    SAX_Parser(){ handler_ = NULL; };
    /**
     * Cxgnhw肵܂
     *
     * \param handler 
     *   Cxg󂯎nh\IuWFNgւ̃|C^
     */
    void setEventHandler(handler_type* handler){
      handler_ = handler;
    };
    /**
     * ̑Oɂ(Cfg)𖳎邩ǂݒ肵܂
     *
     * setIgnoreSpace(true)ꍇACfgɂĐ`ꂽ
     * XMLhLgȒPɏ邱Ƃł܂
     */
    void setIgnoreSpace(bool flag) { ignore_space_ = flag; };
    /**
     * ^ꂽ͂SAX_EventHandlerɓK؂ȃCxgN܂
     *
     * handlerw肵ĂȂꍇParsingException𓊂܂
     * \param text ͂镶
     */
    bool parse(const string_type& text);
    /**
     * ^ꂽXg[͂ASAX_EventHandlerɓK؂ȃCxgN܂
     *
     * handlerw肵ĂȂꍇParsingException𓊂܂
     * \param is ̓Xg[
     */
    bool parse(std::basic_istream<charT, char_traits>& is);
  };
}

#ifndef MIX_SAXPARSER_CPP_
#include "SAX_Parser.cpp"
#endif

#endif
