// -*- mode: C++ -*-
#ifndef __MIX_NODELIST_H_
#define __MIX_NODELIST_H_

#include "classes.h"

#include <list>
 
namespace MiX{
  /**
   * Nodei[郊Xg
   *
   * ςCe[^ȊOlist\<Node\<...\>*\>
   * Ɠ
   */
  template <class charT,class traitsT>
  class NodeList : public std::list<Node<charT,traitsT>* >{
  public:
    typedef Node<charT,traitsT>* value_type;
    typedef NodeList<charT,traitsT> this_type;
    typedef typename std::list<value_type>::iterator iterator;
    typedef typename std::list<value_type>::const_iterator const_iterator;

#ifdef MiX_COMPILER_SUPPORT_MEMBER_TEMPLATE
    /**
     * NodeListp̌^wCe[^
     *
     * Ce[^Ɍ^^邱ƂŃLXgȂŃm[hɃANZXł܂
     * NodeList\<...\>::Iterator\<Element\<...\> \>
     * NodeListElementvfɂANZXCe[^ŁA
     * (*it)Node\<...\>*ł͂ȂAElement\<...\>&w܂
     * ɂă_ELXg̕KvȂȂ܂
     */
    template <class NodeT>
    class Iterator{
      typedef NodeT* pointer;
      typedef NodeT& reference;

      typedef NodeList<charT,traitsT> container_type;
      typedef container_type::iterator basic_iterator;
      typedef Iterator<NodeT> this_type;

      basic_iterator it_;
      container_type* container_;
      
      ///RXgN^
      Iterator(container_type* container,basic_iterator it){
	container_ = container;
	it_ = it;
      };
    public:
      /**
       * RXgN^
       *
       * Iterator𐶐܂
       */
      Iterator(){
	container_ = NULL;
      };
      ///QƊO
      reference operator*(){
	return dynamic_cast<NodeT&>(**it_);
      };
      ///oɃANZX܂
      pointer operator->(){
	return dynamic_cast<NodeT*>(*it_);
      };
      ///Ce[^i߂܂(OuCNg)
      this_type operator++(){
	basic_iterator itEnd=container_->end();
	++it_;
	while(it_!=itEnd){
	  if((*it_)->getType()==NodeT::type()) break;
	  ++it_;
	}
	return *this;
      };
      ///Ce[^߂܂(OufNg)
      this_type operator--(){
	basic_iterator itBegin=container_->begin();
	while(it_!=itBegin){
	  --it_;
	  if((*it_)->getType()==NodeT::type()) break;
	}
	return *this;
      };
      /**
       * Ce[^i߂܂(uCNg)
       *
       * uCNg͑OuCNgɂĎĂ܂
       * ̂ŁA߂l𗘗pȂꍇ͑Ou𗘗pقIł
       */
      this_type operator++(int dmy){
	this_type ret = *this;
	++(*this);
	return ret;
      };
      /**
       * |C^߂܂(ufNg)
       *
       * ufNg͑OufNgɂĎĂ܂
       * ̂ŁA߂l𗘗pȂꍇ͑Ou𗘗pقIł
       */
      this_type operator--(int dmy){
	this_type ret = *this;
	--(*this);
	return ret;
      };
      //Ce[^r܂
      bool operator==(this_type& r)const{
	return it_==r.it_;
      };
      //Ce[^r܂
      bool operator!=(this_type& r)const{
	return !(*this==r);
      };
     
      friend class NodeList<charT,traitsT>;
    };
    /**
     * NodeListp̌^wCe[^(const)
     */
    template <class NodeT>
    class ConstIterator{
      typedef const NodeT* pointer;
      typedef const NodeT& reference;

      typedef NodeList<charT,traitsT> container_type;
      typedef container_type::const_iterator basic_iterator;
      typedef ConstIterator<NodeT> this_type;

      basic_iterator it_;
      container_type* container_;
      
      ///RXgN^
      ConstIterator(container_type* container,basic_iterator it){
	container_ = container;
	it_ = it;
      };
    public:
      /**
       * RXgN^
       *
       * Iterator𐶐܂
       */
      ConstIterator(){ container_ = NULL; };
      ///oɃANZX܂
      pointer operator->(){return dynamic_cast<pointer>(*it_); };
      ///QƊO
      reference operator*(){return dynamic_cast<reference>(**it_);};
      ///Ce[^i߂܂(OuCNg)
      this_type operator++(){
	basic_iterator itEnd=container_->end();
	++it_;
	while(it_!=itEnd){
	  if((*it_)->getType()==NodeT::type()) break;
	  ++it_;
	}
	return *this;
      };
      ///Ce[^߂܂(OufNg)
      this_type operator--(){
	basic_iterator itBegin=container_->begin();
	while(it_!=itBegin){
	  --it_;
	  if((*it_)->getType()==NodeT::type()) break;
	}
	return *this;
      };
      /**
       * Ce[^i߂܂(uCNg)
       *
       * uCNg͑OuCNgɂĎĂ܂
       * ̂ŁA߂l𗘗pȂꍇ͑Ou𗘗pقIł
       */
      this_type operator++(int dmy){
	this_type ret = *this;
	++(*this);
	return ret;
      };
      /**
       * |C^߂܂(ufNg)
       *
       * ufNg͑OufNgɂĎĂ܂
       * ̂ŁA߂l𗘗pȂꍇ͑Ou𗘗pقIł
       */
      this_type operator--(int dmy){
	this_type ret = *this;
	--(*this);
	return ret;
      };
      //Ce[^r܂
      bool operator==(this_type& r)const{
	return it_==r.it_;
      };
      //Ce[^r܂
      bool operator!=(this_type& r)const{
	return !(*this==r);
      };
     
      friend class NodeList<charT,traitsT>;
    };

  public:
    ///ŏ̗vf^wCe[^𓾂܂
    template <class NodeT>
    Iterator<NodeT> Begin(){
      this_type::Iterator<NodeT> ret = this_type::Iterator<NodeT>(this,begin());
      if((*(ret.it_))->getType()!=NodeT::type()) ++ret;
      return ret;
    };
    ///ŏ̗vf^wCe[^𓾂܂(const)
    template <class NodeT>
    ConstIterator<NodeT> Begin()const{
      this_type::ConstIterator<NodeT> ret = this_type::ConstIterator<NodeT>(this,begin());
      if((*(ret.it_))->getType()!=NodeT::type()) ++ret;
      return ret;
    };
    ///Ō̗vf̈^wCe[^𓾂܂
    template <class NodeT>
    Iterator<NodeT> End(){
      return this_type::Iterator<NodeT>(this,end());
    };
    ///Ō̗vf̈^wCe[^𓾂܂(const)
    template <class NodeT>
    ConstIterator<NodeT> End()const{
      return this_type::ConstIterator<NodeT>(this,end());
    };
#endif
  };
}


#endif
