#define MIX_NODECONTAINER_CPP_

#include "NodeContainer.h"
#include "NodeList.h"
#include "Functions.h"

#include <algorithm>
#include <functional>

namespace MiX{
  template <class charT,class traitsT>
  NodeContainer<charT,traitsT>::~NodeContainer()throw(){
    try{
      nodelist_type lst(getChildren());
      for(typename nodelist_type::iterator it=lst.begin();it!=lst.end();++it)
	delete (*it);
    }catch(...){
      //ONĂ܂ꍇ͖B
    }
  }
  
  template <class charT,class traitsT>
  void NodeContainer<charT,traitsT>::addChild(node_type* node){
    typename nodelist_type::iterator it = std::find(getChildren().begin(),getChildren().end(),node);
    if(it!=children_.end()){ 
      std::ostringstream ss;
      ss << "DOM_Exception" << std::endl
	 << __FILE__ << ':' << __LINE__
	 << "Pointer duplication"<< std::endl << std::ends;
      throw DOM_Exception<charT,traitsT>(this,NodeDuplication,ss.str());
    }
    children_.push_back(node);
    node->setParent(*this);
  };

  template <class charT,class traitsT>
  Element<charT,traitsT>& NodeContainer<charT,traitsT>::getElement(const string_type& name,int index){
    int i = 0;
    NamedNodeFinder<charT,traitsT> pred(Node_Element,name);
    typename nodelist_type::iterator first=getChildren().begin();
    typename nodelist_type::iterator last=getChildren().end();
    while(1){
      typename nodelist_type::iterator it;
      it=std::find_if(first,last,pred);
      if(it==getChildren().end()) break;
      if(index==i) return dynamic_cast<element_type&>(**it);
      else first=++it;
      i++;
    };
    std::ostringstream ss;
    ss << "DomException" << std::endl
       << __FILE__ << ':' << __LINE__ << std::endl
       << "Element not found. (" << name << ',' << index 
       << ')' << std::endl << std::ends;
    throw DOM_Exception<charT,traitsT>(this,NodeNotFound,ss.str());
  }
  
  template <class charT,class traitsT>
  Attribute<charT,traitsT>& NodeContainer<charT,traitsT>::getAttribute(const string_type& name){
    NamedNodeFinder<charT,traitsT> pred(Node_Attribute,name);
    typename nodelist_type::iterator it = std::find_if(getChildren().begin(),getChildren().end(),pred);
    if(it==getChildren().end()){
      std::ostringstream ss;
      ss << "DOM_Exception" << std::endl
	 << __FILE__ << ':' << __LINE__ << std::endl
	 << "Attribute not found(" << name << ")" 
	 << std::endl << std::ends;
      throw DOM_Exception<charT,traitsT>(this,NodeNotFound,ss.str());
    }
    return dynamic_cast<attribute_type&>(**it);
  }

  template <class charT,class traitsT>
  bool NodeContainer<charT,traitsT>::hasAttribute(const string_type& name){
    NamedNodeFinder<charT,traitsT> pred(Node_Attribute,name);
    typename nodelist_type::iterator it;
    it = std::find_if(getChildren().begin(),getChildren().end(),pred);
    return it!=getChildren().end();
  }
  
  template <class charT,class traitsT>
  NodeList<charT,traitsT> NodeContainer<charT,traitsT>::getElementsByTagName(const string_type& tagname){
    nodelist_type ret;
    typename nodelist_type::iterator it = getChildren().begin();
    typename nodelist_type::iterator last = getChildren().end();
    for( ; it!=last ; ++it ){
      if((*it)->getType()==Node_Element){
	element_type& el = dynamic_cast<element_type&>(**it);
	if(el.getName()==tagname){
	  ret.push_back(&el);
	}
	nodelist_type lst = el.getElementsByTagName(tagname);
	ret.insert(ret.end(),lst.begin(),lst.end());
      }
    }
    return ret;
  }
}
