#define MIX_NODE_CPP_

#include <algorithm>
#include "XMLString.h"
#include "NodeList.h"
#include "Node.h"
#include "DOM_Exception.h"

namespace MiX{
  template <class charT,class traitsT>
  Node<charT,traitsT>::~Node()throw(){
    if(parent_){
      nodelist_type& l=parent_->getChildren();
      typename nodelist_type::iterator it = std::find(l.begin(),l.end(),this);
      if(it != l.end()){
	parent_->getChildren().erase(it);
      }
      parent_ = 0;
    }
  };
  
  template <class charT,class traitsT>
  const NodeContainer<charT,traitsT>& Node<charT,traitsT>::getParent()const{
    if(parent_ == 0){
      std::ostringstream ss;
      ss << "DOM_Exception" << std::endl
	 << __FILE__ << ':' << __LINE__ << std::endl
	 << "Parent not found." << std::endl << std::ends;
      throw DOM_Exception<charT,traitsT>(this,NullException,ss.str());
    }
    return *parent_;
  };
  
  template <class charT,class traitsT>
  NodeContainer<charT,traitsT>& Node<charT,traitsT>::getParent(){
    if(parent_ == 0){
      std::ostringstream ss;
      ss << "DOM_Exception" << std::endl
	 << __FILE__ << ':' << __LINE__ << std::endl
	 << "Parent not found." << std::endl << std::ends;
      throw DOM_Exception<charT,traitsT>(this,NullException,ss.str());
    }
    return *parent_;
  };
}
