#define MIX_DOCUMENT_CPP_

#include <iostream>
#include <sstream>

#include "classes.h"
#include "config.h"
#include "Document.h"
#include "Comment.h"
#include "DOM_Exception.h"
#include "NodeList.h"

namespace MiX{

  template <class charT,class traitsT>
  Element<charT,traitsT>& Document<charT,traitsT>::getRoot()const{
    typename nodelist_type::const_iterator it;
    NodeTypeChecker<charT,traitsT> pred(Node_Element);
    it = std::find_if(getChildren().begin(),getChildren().end(),pred);
    if(it!=getChildren().end()) return dynamic_cast<element_type&>(**it);
    std::ostringstream ss;
    ss << "DOM_Exception" << std::endl
       << __FILE__ << ':' << __LINE__ << std::endl
       << "RootNode not found" << std::endl << std::ends;
    throw DOM_Exception<charT,traitsT>(this,NodeNotFound,ss.str());
  }
  
  template <class charT,class traitsT>
  XMLString<charT,traitsT> Document<charT,traitsT>::toString(bool is_indent,int indent_off)const{
    string_type s;
    if(is_indent) insertIndent(indent_off,s,xml_traits::tab());
    s += xml_traits::lt(); s += xml_traits::question(); 
    s += xml_traits::xml();
    //qAgr[g̕
    typename nodelist_type::const_iterator it = getChildren().begin();
    typename nodelist_type::const_iterator last = getChildren().end();
    for( ;it!=last;++it){
      if((*it)->getType()==Node_Attribute){
	s += xml_traits::sp();
	s += (*it)->toString();
      }
    }
    s += xml_traits::question(); s += xml_traits::gt();
    if(is_indent) s += xml_traits::crlf();
    s += getRoot().toString(is_indent,indent_off);
    return s;
  };

  template <class charT,class traitsT>
  Document<charT,traitsT>& Document<charT,traitsT>::clone()const{
    document_type& ret = document_type::create(getRoot().getName());
    typename nodelist_type::const_iterator it = getChildren().begin();
    typename nodelist_type::const_iterator last = getChildren().end();
    //hLgAgr[g̃N[
    for( ; it!=last ; ++it ){
      if((*it)->getType()==Node_Attribute){
	const attribute_type& att = dynamic_cast<const attribute_type&>(**it);
	att.clone(ret);
      }
    }
    //[gm[h̎qm[h̃N[
    it = getRoot().getChildren().begin();
    last = getRoot().getChildren().end();
    for( ; it != last ; ++it ){
      // ͉̕...
      if((*it)->getType()==Node_Element){
	const element_type& el = dynamic_cast<const element_type&>(**it);
	el.clone(ret.getRoot());
      }else if((*it)->getType()==Node_Attribute){
	const attribute_type& att = dynamic_cast<const attribute_type&>(**it);
	att.clone(ret.getRoot());
      }else if((*it)->getType()==Node_Text){
	const text_type& txt = dynamic_cast<const text_type&>(**it);
	txt.clone(ret.getRoot());
      }else if((*it)->getType()==Node_Comment){
	const comment_type& com = dynamic_cast<const comment_type&>(**it);
	com.clone(ret.getRoot());
      }else{
	std::ostringstream sout;
	sout << "DOM_Exception" << std::endl
	     << "Invalid DOM Tree"<<std::endl<<std::ends;
	throw DOM_Exception<charT,traitsT>(this,InvalidNodeFound,sout.str());
      }
    }
    return ret;
  }

  template <class charT,class traitsT>
  Document<charT,traitsT>& Document<charT,traitsT>::create(const XMLString<charT,traitsT>& rootname){
    document_type* newdoc = new document_type();
    element_type* newel = new element_type(rootname);
    newel->setParent(*newdoc);
    newdoc->getChildren().push_back(newel);
    return *newdoc;
  }
}
