// -*- mode: c++ -*-
#ifndef MIX_ATTRIBUTE_H_
#define MIX_ATTRIBUTE_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"
#include "NamedNode.h"
#include "Value.h"
#include "extern/noncopyable.hpp"
namespace MiX{
  /**
   * ElementDocument̑\NXł.
   *
   * lƖOێ܂
   */
  template <class charT,class traitsT>
  class Attribute : boost::noncopyable,
		    public Value<charT,traitsT> ,
		    public NamedNode<charT,traitsT>{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef Attribute<charT,traitsT> this_type;
    typedef NodeContainer<charT,traitsT> nodecontainer_type;
  protected:
    /**
     * RXgN^
     *
     * AttributẽRXgN^͒ڌĂׂ܂<br>
     * Attribute<...>::createŐĂ
     */
    Attribute(const string_type& name,const string_type& val)
      : Value<charT,traitsT>(val),
	NamedNode<charT,traitsT>(name){ };
  public:
    ///fXgN^
    virtual ~Attribute()throw() { };
    ///̃m[h̃^Cv𓾂܂
    virtual NodeType getType()const { return Node_Attribute; };
    /**
     * ÓIɃNXNodeType𓾂܂.
     *
     * Node_AttributeԂ܂
     */
    static NodeType type(){ return Node_Attribute; };
    /**
     * Attribute̕\𓾂܂.
     *
     * ͑SĖ܂
     */
    virtual string_type toString(bool dmy=false,int dmy2=0)const;

    /**
     * Attribute𕡐܂
     *
     *  \param parent ̐em[h
     */
    this_type& clone(nodecontainer_type& parent) const
      { return attribute_type::create(getName(),getValue(),parent); };

    /**
     * Attribute𐶐܂.
     *
     * \param key Attribute̖O
     * \param val Attribute̒l
     * \param parent Attribute̐em[h
     */
    static this_type& create(const string_type& key,const string_type& val,nodecontainer_type& parent);
    
    friend class DOM_Parser<charT,traitsT>;
  };
}

#ifndef MIX_ATTRIBUTE_CPP_
#include "Attribute.cpp"
#endif//MIX_ATTRIBUTE_CPP_

#endif
