#include <iostream>

#include <MiX/MiX.h>

class EventHandler : public MiX::SAX_EventHandler<char>{
  int indent_;
  std::ostream& out_;
public:
  EventHandler(std::ostream& out) : out_(out){
    indent_ = 0;
  }
  virtual void onXMLDeclaration(MiX::AttrMap<char> attr){
    out_ << "<html>" << std::endl
	 << "<head><title>xml2html</title></head>" 
	 << std::endl << "<body>" << std::endl;
  }
  virtual void onStart(MiX::XMLString<char> name,MiX::AttrMap<char> attr){
    out_ << "<div style=\"margin-left:" << 40*indent_
	 << "px\">" << "<b>&lt;" << name << "</b>" << std::endl;
    MiX::AttrMap<char>::iterator it = attr.begin();
    for( ;it!=attr.end();it++){
      out_ << " " << it->first 
	   << " = <span style=\"color: #000055;\">\'" 
	   << it->second << "\'</span>" << std::endl;
    }
    out_ << "<b>&gt;</b>" << std::flush;
    out_ << "</div>" << std::endl;
    ++indent_;
  }
  virtual void onEnd(MiX::XMLString<char> name){
    indent_--;
    out_ << "<div style=\"margin-left:" << 40*indent_
	 << "px\">" << "<b>&lt;/" << name << "&gt;</b>" 
	 << "</div>";
    if(indent_==0){
      out_ << "</body></html>" << std::endl;
    }
  }
  virtual void onText(MiX::XMLString<char> text){
    out_ << "<div style=\"margin-left:" << 40*indent_
	 << "px\">" << text << "</div>" << std::endl;
  }
  virtual void onComment(MiX::XMLString<char> text){
    out_ << "<div style=\"margin-left:" << 40*indent_
	 << "px\">" << "<span style=\"color: #777777;\">" 
	 << "&lt;!-" << text << "--&gt;" 
	 << "</span>" << "</div>" << std::endl;
  }
};

int main(int argc,char* argv[]){
  try{
    MiX::SAX_Parser<char> parser;
    EventHandler handler(std::cout);
    parser.setIgnoreSpace(true);
    parser.setEventHandler(&handler);
    parser.parse(std::cin);

    return 0;
  }catch(MiX::ParsingException& e){
    std::cerr << e.what() << std::endl;
    return -1;
  }
}

