// -*- mode: c++ -*-
#ifndef MiX_DEFAULTXMLTRAITS_H_
#define MiX_DEFAULTXMLTRAITS_H_

// Adlib/DefaultXMLTraits.h
// (C) Copyright KUBO,Yotaro.
// [o[W]
// 0.4.7
//   - DefaultXMLTraits.cppIncludeGuard}N̕ύX
#include <string>
#include "config.h"

namespace MiX{

  template <class charT,class char_traits>
  class DefaultXMLTraits{
  public:
    typedef std::basic_string<charT,char_traits> basic_string_type;
  private:
    static basic_string_type makeString(const char* szSrc);

  public:
    ///̏I킷Ԃ܂
    static charT null(){ return static_cast<charT>('\0'); }
    ///s̏I킷Ԃ܂
    static charT crlf(){ return static_cast<charT>('\n'); }
    ///󔒕Ԃ܂
    static charT sp(){ return static_cast<charT>(' '); }
    ///^uԂ܂
    static charT tab(){ return static_cast<charT>('\t'); }

    ///'<'ɑ镶Ԃ܂
    static charT lt(){ return static_cast<charT>('<'); }
    ///'='ɑ镶Ԃ܂
    static charT eq(){ return static_cast<charT>('='); }
    ///'>'ɑ镶Ԃ܂
    static charT gt(){ return static_cast<charT>('>'); }

    ///'/'ɑ镶Ԃ܂
    static charT slash(){ return static_cast<charT>('/'); }
    ///'-'ɑ镶Ԃ܂
    static charT hyphen(){ return static_cast<charT>('-'); }
    ///':'ɑ镶Ԃ܂
    static charT colon() { return static_cast<charT>(':'); }
    ///';'ɑ镶Ԃ܂
    static charT semicolon(){ return static_cast<charT>(';'); }

    ///'!'ɑ镶Ԃ܂
    static charT exclamation(){ return static_cast<charT>('!'); }
    ///'?'ɑ镶Ԃ܂
    static charT question(){ return static_cast<charT>('?'); }
    ///'&'ɑ镶Ԃ܂
    static charT amp(){ return static_cast<charT>('&'); }

    ///'\"'ɑ镶Ԃ܂
    static charT dblquote() { return static_cast<charT>('\"'); }
    ///'\''ɑ镶Ԃ܂
    static charT quote() { return static_cast<charT>('\''); }

    //񏈗
    //XMLŎg镶ԂB
    ///"xml"ɑ镶Ԃ܂
    static basic_string_type xml(){ 
      return makeString("xml");
    }
    ///"CDATA"ɑ镶Ԃ܂
    static basic_string_type cdata(){
      return makeString("CDATA");
    }
    ///"lt"ɑ镶Ԃ܂
    static basic_string_type str_lt(){
      return makeString("lt");
    }
    ///"gt"ɑ镶Ԃ܂
    static basic_string_type str_gt(){
      return makeString("gt");
    }
    ///"amp"ɑ镶Ԃ܂
    static basic_string_type str_amp(){
      return makeString("amp");
    }
    ///"quot"ɑ镶Ԃ܂
    static basic_string_type str_quot(){
      return makeString("quot");
    }
    ///"apos"ɑ镶Ԃ܂
    static basic_string_type str_apos(){
      return makeString("apos");
    }

    ///"xmlns"ɑ镶Ԃ܂
    static basic_string_type str_xmlns(){ 
      return makeString("xmlns");
    }

    /**
     * 啶ʂȂrs܂
     *
     * s1s2nڂ܂ŔׁA
     * s1>s2̂Ƃ͂͐̒l
     * s1==s2̂Ƃ0
     * s1<s2̂Ƃ͕̒lԂ܂
     */
    static int ci_compare(const charT* s1,const charT* s2,size_t n){
      for(size_t i=0;i<n;i++){
	int c1,c2;
	c1 = std::tolower(static_cast<int>(s1[i]));
	c2 = std::tolower(static_cast<int>(s2[i]));
	if(c1>c2) return 1;
	if(c1<c2) return -1;
      }
      return 0;
    }
    
  };
}

#ifndef MiX_DEFAULTXMLTRAITS_CPP_
#include "DefaultXMLTraits.cpp"
#endif

#endif
