from Globals import InitializeClass, DTMLFile
from App.ImageFile import ImageFile
from Acquisition import Implicit
from Globals import Persistent
from OFS.SimpleItem import Item
#from OFS.PropertyManager import PropertyManager
from MindMap import MindMap, MindMapRoot, XML2MindMapRoot

manage_addFunctionForm=DTMLFile('dtml/add', globals())
def manage_addFunction(context, id, title, REQUEST=None):
  """ add function """
  p = MindMapBBS(id, title)
  context._setObject(id, p)
  if REQUEST is not None:
    context.manage_main(context, REQUEST)

class MindMapBBS(Implicit, Persistent, Item):
  meta_type = 'MindMapBBS'
  _properties = (
    {'id':'title',   'type':'string', 'mode':'w'},
  )
  index_html = DTMLFile('dtml/index_html', globals())
  view = DTMLFile('dtml/view', globals())
  editForm = DTMLFile('dtml/edit', globals())
  triangle = DTMLFile('dtml/triangle', globals())
  mind_branch = DTMLFile('dtml/mind_branch', globals())
  mind_leaf = DTMLFile('dtml/mind_leaf', globals())
  mind_leaf_view = DTMLFile('dtml/mind_leaf_view', globals())
  mind_leaf_edit = DTMLFile('dtml/mind_leaf_edit', globals())

  xml = DTMLFile('dtml/xml', globals())
  xml_leaf = DTMLFile('dtml/xml_leaf', globals())

  manage_options = (
    {'label' : 'Edit', 'action' : 'editForm'},
    {'label' : 'View', 'action' : 'index_html'},
    )


  def __init__(self, id, title):
    """ init """
    self.id = id
    self.title = title
    self.root = MindMapRoot()
    self.root.add(None, 'root')
    self._p_changed = 1

  def __call__(self, client=None, REQUEST={}, RESPONSE=None, **kw):
    """ call from dtml var """
    return self.view.__call__(client, REQUEST, RESPONSE, kw)

  def root_message(self):
    return self.root.getRoot().message

  def manage_edit(self, title, xml_string, REQUEST=None):
    """ set project setting """
    self.title = title
    self.root = XML2MindMapRoot().createFromXML(xml_string)

    if REQUEST is not None:
      return self.editForm(REQUEST,
                           manage_tabs_message="Saved changes.")

  def action(self, command, code, mmb_url, return_url, color=None, message=None, link=None, linkType=None, REQUEST=None):
    """ action """
    if command == 'edit':
      self.root.change(code, message, color, link, linkType)
      self.root.refresh()
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code
      
    if command == 'add':
      child = self.root.add(code, '')
      self._p_changed = 1
      return_url += '?code=' + child.code + '&mmb_url=' + mmb_url
      return_url += '#MMB' + mmb_url + '-' + child.code
      
    if command == 'change':
      return_url += '?code=' + code + '&mmb_url=' + mmb_url
      return_url += '#MMB' + mmb_url + '-' + code

    if command == 'forward':
      self.root.refresh()
      self.root.decode_map[code].moveForward()
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code

    if command == 'back':
      self.root.refresh()
      self.root.decode_map[code].moveBack()
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code

    if command == 'up':
      self.root.refresh()
      self.root.decode_map[code].moveUp()
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code

    if command == 'down':
      self.root.refresh()
      self.root.decode_map[code].moveDown()
      self._p_changed = 1
      return_url += '#MMB' + mmb_url + '-' + code

    if REQUEST is not None:
      REQUEST.RESPONSE.redirect(return_url)
    


InitializeClass(MindMapBBS)
