(function(){
var DEV=LPCXpresso1769;
var BCF=DEV._BCF;
var EE=DEV._EE;
var isUndef=MiMicLib.isUndef;
/**
 * @see API manual
 */
DEV.Peripheral=function(i_mcu,i_phy,i_opt)
{
	try{
		if(isUndef(i_phy)){
			throw new MiMicException(EE.INVALID_PHY);
		}
		this._mcu=i_mcu;
		this._phy=i_phy;
		//オプション設定するならする。
		if(!isUndef(i_opt)){
			this.setOpt(i_opt);
		}
	}catch(e){
		throw new MiMicException(e);
	}	
}
DEV.Peripheral.prototype=
{
	_PCLKSEL:[0x400FC1A8,0x400FC1AC],
	_PCONP:0x400FC0C4,
	_phy:null,
	_mif:null,
	BCF_setOpt:function BCF_setOpt(i_opt,i_db)
	{
		try{
			var bc="";
			//pconp
			if(!isUndef(i_opt.power)){
				if(this._phy[2]==null){
					throw new MiMicException(EE.INVALID_CFG,"The pin does not support PCONP.");
				}
				//pinselAddrを得る
				bc+=BCF.setBit(this._PCONP,0x00000001,i_opt.power,this._phy[2],i_db);
			}
			//clock
			if(!isUndef(i_opt.clock)){
				if(this._phy[0]==null){
					throw new MiMicException(EE.INVALID_CFG,"The pin does not support PCLKSEL.");
				}
				bc+=BCF.setBit(this._PCLKSEL[this._phy[0]],0x00000003,i_opt.clock,this._phy[1],i_db);
			}
			return bc;
		}catch(e){
			throw new MiMicException(e);
		}		
	},
	/**
	 * @see API manual
	 */
	setOpt:function setOpt(i_opt)
	{
		try{
			var db=new Array();
			var bc=this.BCF_setOpt(i_opt,db);
			if(bc.length==0){
				throw new MiMicException("i_opt is empty or invalid.");
			}
			//MiMicBCを生成して実行
			this._mcu.callMiMicWithCheck(bc+BCF.END,db);

		}catch(e){
			throw new MiMicException(e);
		}
		return;		
	}
}

}());