/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#ifndef NYLPC_CSYNCCALL_H_
#define NYLPC_CSYNCCALL_H_


typedef struct NyLPC_TcSyncCall NyLPC_TcSyncCall_t;

#include "NyLPC_stdlib.h"
#include "NyLPC_cSyncProc.h"

/**********************************************************************
 *
 * NyLPC_TcSyncCall
 *
 **********************************************************************/
#if NyLPC_ARCH==NyLPC_ARCH_FREERTOS

struct NyLPC_TcSyncCall
{
	xSemaphoreHandle _q;
	NyLPC_TcSyncProc_t* _last_proc;
};


NyLPC_TBool NyLPC_cSyncCall_initialize(NyLPC_TcSyncCall_t* i_inst);
NyLPC_TBool NyLPC_cSyncCall_call(NyLPC_TcSyncCall_t* i_inst,NyLPC_TcSyncProc_t* i_to,void* i_msg,NyLPC_TUInt32 i_wait_msec);

#elif NyLPC_ARCH==NyLPC_ARCH_WIN32
#else
#error Bad NyLPC_ARCH!
#endif


#endif /* NYLPC_CSYNCCALL_H_ */
