.\" DO NOT MODIFY THIS FILE! it was generated by rd2
.TH MILTER\-TEST\-SERVER 1 "March 2012" "milter manager" "milter manager's manual"
.SH NAME
.PP
milter\-test\-server \- MTA side milter protocol implemented program
.SH SYNOPSIS
.PP
\&\fBmilter\-test\-server\fP [\fIoption ...\fP]
.SH DESCRIPTION
.PP
milter\-test\-server talks MTA side milter protocol. It can connect to a milter without MTA. For now, there is no similar tool. It is useful to test milter not MTA + milter. For example, it can be used for the following situation:
.IP
.B
\(bu
milter's performance check
.IP
.B
\(bu
milter's operation check
.PP
milter\-test\-server can be used for simple performance check because it shows elapsed time. You can confirm elapsed time without MTA's processing time. You will find a problem of a milter more easily because it doesn't depend on MTA.
.PP
If a milter changes headers and/or body, milter\-test\-server can show changed message. It can be used for testing a milter that may change headers and/or body. If it is used with unit testing framework like Cutter, you can write automated unit tests.
.SH Options
.TP
.fi
.B
\-\-help
Shows available options and exits.
.TP
.fi
.B
\-\-name=NAME
Uses NAME as milter\-test\-server's name. The name is used as a value of "{daemon_name}" macro for example.

The default value is "milter\-test\-server" that is the command file name.
.TP
.fi
.B
\-\-connection\-spec=SPEC
Specifies a socket to connect to milter. SPEC should be formatted as one of the followings:
.IP
.B
\(bu
unix:PATH
.IP
.B
\(bu
inet:PORT
.IP
.B
\(bu
inet:PORT@HOST
.IP
.B
\(bu
inet:PORT@[ADDRESS]
.IP
.B
\(bu
inet6:POST
.IP
.B
\(bu
inet6:PORT@HOST
.IP
.B
\(bu
inet6:PORT@[ADDRESS]

Examples:
.IP
.B
\(bu
unix:/var/run/milter/milter\-manager.sock
.IP
.B
\(bu
inet:10025
.IP
.B
\(bu
inet:10025@localhost
.IP
.B
\(bu
inet:10025@[127.0.0.1]
.IP
.B
\(bu
inet6:10025
.IP
.B
\(bu
inet6:10025@localhost
.IP
.B
\(bu
inet6:10025@[::1]
.TP
.fi
.B
\-\-negotiate\-version=VERSION
Uses VERSION as milter protocol version sent to milter.

The default value is 8. The value is the same as Sendmail 8.14's default value.
.TP
.fi
.B
\-\-connect\-host=HOST
Uses HOST as connected host.

The host name is passed to milter's xxfi_connect() callback.
.TP
.fi
.B
\-\-connect\-address=SPEC
Uses SPEC as connected address. SPEC format is same as \-\-connection\-spec option's SPEC.

The address is passed to milter's xxfi_connect() callback.
.TP
.fi
.B
\-\-connect\-macro=NAME:VALUE
Adds a macro that is sent on xxfi_connect() callback. The macro has NAME name and VALUE value. This option can be specified N\-times for N additional macros.

Here is an example that a macro that has "client_connections" name and "1" value is sent on xxfi_connect() callback:

.nf
\&    \-\-connect\-macro client_connections:1
.fi
.TP
.fi
.B
\-\-helo\-fqdn=FQDN
Uses FQDN for 'HELO/EHLO' SMTP command.

The FQDN is passed to milter's xxfi_helo() callback.
.TP
.fi
.B
\-\-helo\-macro=NAME:VALUE
Adds a macro that is sent on xxfi_helo() callback. The macro has NAME name and VALUE value. This option can be specified N\-times for N additional macros.

Here is an example that a macro that has "client_ptr" name and "unknown" value is sent on xxfi_helo() callback:

.nf
\&    \-\-helo\-macro client_ptr:unknown
.fi
.TP
.fi
.B
\-\-envelope\-from=FROM, \-fFROM
Uses FROM for 'MAIL FROM' SMTP command.

The address is passed to milter's xxfi_envfrom() callback.
.TP
.fi
.B
\-\-envelope\-from\-macro=NAME:VALUE
Adds a macro that is sent on xxfi_envfrom() callback. The macro has NAME name and VALUE value. This option can be specified N\-times for N additional macros.

Here is an example that a macro that has "client_addr" name and "192.168.0.1" value is sent on xxfi_envfrom() callback:

.nf
\&    \-\-envelope\-from\-macro client_addr:192.168.0.1
.fi
.TP
.fi
.B
\-\-envelope\-recipient=RECIPIENT, \-rRECIPIENT
Uses RECIPIENT for 'RCPT TO' SMTP command. If you want to use multiple recipients, specify \-\-envelope\-recipient option n\-times.

The address is passed to milter's xxfi_envrcpt() callback. xxfi_envrcpt() is called for each recipient.
.TP
.fi
.B
\-\-envelope\-recipient\-macro=NAME:VALUE
Adds a macro that is sent on xxfi_envrcpt() callback. The macro has NAME name and VALUE value. This option can be specified N\-times for N additional macros.

Here is an example that a macro that has "client_ptr" name and "2929" value is sent on xxfi_envrcpt() callback:

.nf
\&    \-\-envelope\-recipient\-macro client_ptr:2929
.fi
.TP
.fi
.B
\-\-data\-macro=NAME:VALUE
Adds a macro that is sent on xxfi_data() callback. The macro has NAME name and VALUE value. This option can be specified N\-times for N additional macros.

Here is an example that a macro that has "client_name" name and "unknown" value is sent on xxfi_data() callback:

.nf
\&    \-\-data\-macro client_name:unknown
.fi
.TP
.fi
.B
\-\-header=NAME:VALUE
Adds a header that names NAME and its value is VALUE. If you want to multiple headers, specify \-\-header option n\-times.

The header is passed to milter's xxfi_header() callback. xxfi_header() is called for each header.
.TP
.fi
.B
\-\-end\-of\-header\-macro=NAME:VALUE
Adds a macro that is sent on xxfi_eoh() callback. The macro has NAME name and VALUE value. This option can be specified N\-times for N additional macros.

Here is an example that a macro that has "n_headers" name and "100" value is sent on xxfi_eoh() callback:

.nf
\&    \-\-end\-of\-header\-macro n_headers:100
.fi
.TP
.fi
.B
\-\-body=CHUNK
Adds CHUNK as body chunk. If you want to multiple chunks, specify \-\-body option n\-times.

The chunk is passed to milter's xxfi_body() callback. xxfi_body() is called for each chunk.
.TP
.fi
.B
\-\-end\-of\-message\-macro=NAME:VALUE
Adds a macro that is sent on xxfi_eom() callback. The macro has NAME name and VALUE value. This option can be specified N\-times for N additional macros.

Here is an example that a macro that has "elapsed" name and "0.29" value is sent on xxfi_eom() callback:

.nf
\&    \-\-end\-of\-message\-macro elapsed:0.29
.fi
.TP
.fi
.B
\-\-unknown=COMMAND
Uses COMMAND as unknown SMTP command.

The command is passed to milter's xxfi_unknown() callback. xxfi_unknown() is called between xxfi_envrcpt() and xxfi_data().
.TP
.fi
.B
\-\-authenticated\-name=NAME
Uses 
.I NAME
 as an authorized user name on SMTP Auth. It corresponds to SASL login name. 
.I NAME
 is passed as a value of \&\fB{auth_authen}\fP on MAIL FROM.
.TP
.fi
.B
\-\-authenticated\-type=TYPE
Uses 
.I TYPE
 as an authorized type on SMTP Auth. It corresponds to SASL login method. 
.I TYPE
 is passed as a value of \&\fB{auth_type}\fP on MAIL FROM.
.TP
.fi
.B
\-\-authenticated\-author=AUTHOR
Uses 
.I AUTHOR
 as an authorized sender on SMTP Auth. It corresponds to SASL sender. 
.I AUTHOR
 is passed as a value of \&\fB{auth_author}\fP on MAIL FROM.
.TP
.fi
.B
\-\-mail\-file=PATH
Uses file exists at 
.I PATH
 as mail content. If the file has 'From:' and/or 'To:', they are used for from and/or recipient addresses.
.TP
.fi
.B
\-\-output\-message
Shows a message applied a milter. If you want to check milter's operation that may change header and/or body, specify this option.
.TP
.fi
.B
\-\-color=[yes|true|no|false|auto]
Shows a messaged applied a milter with colorization if \-\-color, \-\-color=yes or \-\-color=true is specified. If \-\-color=auto is specified, colorization is enabled on terminal environment.

The default is off.
.TP
.fi
.B
\-\-connection\-timeout=SECONDS
Specifies timeout on connecting to a milter. An error is occurred when a connection can't be established in 
.I SECONDS
 seconds.

The default is 300 seconds. (5 minutes)
.TP
.fi
.B
\-\-reading\-timeout=SECONDS
Specifies timeout on reading a response from a milter. An error is occurred when the milter doesn't respond to a request in 
.I SECONDS
 seconds.

The default is 10 seconds.
.TP
.fi
.B
\-\-writing\-timeout=SECONDS
Specifies timeout on writing a request to a milter. An error is occurred when request to the milter isn't completed in 
.I SECONDS
 seconds.

The default is 10 seconds.
.TP
.fi
.B
\-\-end\-of\-message\-timeout=SECONDS
Specifies timeout on reading a response of end\-of\-message command from a milter. An error is occurred when the milter doesn't complete its response to the end\-of\-message command in 
.I SECONDS
seconds.

The default is 300 seconds. (5 minutes)
.TP
.fi
.B
\-\-threads=N
Use N threads to request a milter.

The default is 0. (main thread only)
.TP
.fi
.B
\-\-verbose
Logs verbosely.

"MILTER_LOG_LEVEL=all" environment variable configuration has the same effect.
.TP
.fi
.B
\-\-version
Shows version and exits.
.SH EXIT STATUS
.PP
The exit status is 0 if milter session is started and non 0 otherwise. milter session can't be started when connection spec is invalid format or milter\-test\-server can't connect to a milter.
.SH EXAMPLE
.PP
The following example talks with a milter that works on host 192.168.1.29 and is listened at 10025 port.
.nf
\&    % milter\-test\-server \-s inet:10025@192.168.1.29
.fi
.SH SEE ALSO
.PP
.BR milter\-test\-client
(1),
.BR milter\-performance\-check
(1)

