/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package mygame;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.util.TempVars;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.OpenNI.Point3D;
import org.OpenNI.SkeletonCapability;
import org.OpenNI.SkeletonJoint;
import org.OpenNI.SkeletonJointOrientation;
import org.OpenNI.SkeletonJointPosition;
import org.OpenNI.SkeletonJointTransformation;
import org.OpenNI.StatusException;
import projectkyoto.jme3.mmd.PMDNode;
import projectkyoto.jme3.mmd.nativebullet.PhysicsControl;
import projectkyoto.mmd.file.PMDModel;

/**
 *
 * @author kobayasi
 */
public class KinectControl4 extends AbstractControl {

    SkeletonCapability skeleton;
    Skeleton modelSkeleton;
    Quaternion leftRot;
    int userId;
    PMDNode pmdNode;
    PhysicsControl physicsControl;

    public KinectControl4() {
    }

    public KinectControl4(SkeletonCapability skeleton, int userId) {
        this.skeleton = skeleton;
        this.userId = userId;
    }

    public SkeletonCapability getSkeleton() {
        return skeleton;
    }

    public void setSkeleton(SkeletonCapability skeleton) {
        this.skeleton = skeleton;
    }

    public int getUserId() {
        return userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    Quaternion convOrientation(SkeletonJointOrientation o1, Quaternion dest) {
        TempVars temp = TempVars.get();
        try {
            temp.tempMat3.set(0, 0, o1.getX1());
            temp.tempMat3.set(0, 1, -o1.getY1());
            temp.tempMat3.set(0, 2, o1.getZ1());

            temp.tempMat3.set(1, 0, -o1.getX2());
            temp.tempMat3.set(1, 1, o1.getY2());
            temp.tempMat3.set(1, 2, -o1.getZ2());

            temp.tempMat3.set(2, 0, o1.getX3());
            temp.tempMat3.set(2, 1, -o1.getY3());
            temp.tempMat3.set(2, 2, o1.getZ3());

            dest.fromRotationMatrix(temp.tempMat3);
            dest.normalizeLocal();
            return dest;
        } finally {
            temp.release();
        }
    }

    Vector3f calcVec(SkeletonJoint fromJoint, SkeletonJoint toJoint, Vector3f result) {
        try {
            Point3D p1 = skeleton.getSkeletonJointPosition(userId, fromJoint).getPosition();
            Point3D p2 = skeleton.getSkeletonJointPosition(userId, toJoint).getPosition();
            result.set(p1.getX() - p2.getX(), p2.getY() - p1.getY(), p1.getZ() - p2.getZ());
            result.normalizeLocal();
            return result;
        } catch (StatusException ex) {
            throw new RuntimeException(ex);
        }
    }
    Vector3f calcVec(Bone fromBone, Bone toBone, Vector3f result) {
        toBone.getModelSpacePosition().subtract(fromBone.getModelSpacePosition(), result);
        result.normalizeLocal();
        return result;
    }
    void updateBone(Bone bone1, Bone bone2, SkeletonJoint fromJoint, SkeletonJoint toJoint) {
        TempVars temp = TempVars.get();
        try {
            bone1.getLocalRotation().loadIdentity();
//            bone2.getLocalRotation().loadIdentity();
            modelSkeleton.updateWorldVectors();
            Vector3f toVec = calcVec(fromJoint, toJoint, temp.vect1);
            temp.quat1.set(bone1.getParent().getModelSpaceRotation());
            temp.quat1.inverseLocal();
            temp.quat1.multLocal(toVec);
            Vector3f fromVec = calcVec(bone1, bone2, temp.vect2);
            temp.quat1.multLocal(fromVec);
            calcRot(fromVec, toVec, bone1.getLocalRotation());
            modelSkeleton.updateWorldVectors();
            calcVec(bone1, bone2, temp.vect3);
//            worldRot.mult(fromVec, temp.vect3);
            
            System.out.println("angle = "+temp.vect3.angleBetween(toVec));
        } finally {
            temp.release();
        }
    }

    /**
     * a = b * out
     * @param a
     * @param b
     * @param out
     * @return 
     */
    Quaternion convRot2(Quaternion a, Quaternion b, Quaternion out) {
        TempVars temp = TempVars.get();
        temp.quat1.set(b);
        temp.quat1.inverseLocal();
        float angle = a.toAngleAxis(temp.vect1);
        temp.quat1.multLocal(temp.vect1);
        out.fromAngleAxis(angle, temp.vect1);
        temp.release();
        return out;
    }

    Quaternion convRot(Quaternion a, Quaternion b, Quaternion out) {
        TempVars temp = TempVars.get();
        temp.quat1.set(b);
        temp.quat1.inverseLocal();
        temp.quat1.mult(a, out);
//        out.set(temp.quat1);
        temp.release();
        return out;
    }

    Quaternion calcRot(Vector3f fromVec, Vector3f toVec, Quaternion out) {
        TempVars temp = TempVars.get();
        try {
            float angle = toVec.angleBetween(fromVec);
            toVec.cross(fromVec, temp.vect1);
            temp.vect1.normalizeLocal();
            out.fromAngleAxis(-angle, temp.vect1);
            out.normalizeLocal();
            return out;
        } finally {
            temp.release();
        }
    }

    void updateBoneRotation(Bone bone, SkeletonJoint joint) {
        TempVars temp = TempVars.get();
        try {
            convOrientation(skeleton.getSkeletonJointOrientation(userId, joint), temp.quat1);
            bone.getLocalRotation().loadIdentity();
            modelSkeleton.updateWorldVectors();
            convRot(temp.quat1, bone.getParent().getModelSpaceRotation(), temp.quat2);
            bone.getLocalRotation().set(temp.quat2);

            modelSkeleton.updateWorldVectors();
//            System.out.println("q = "+tmpQ2);
        } catch (StatusException ex) {
//            throw new RuntimeException(ex);
        } finally {
            temp.release();
        }
    }

    Quaternion calcLeftShoulderInitialRotation(Skeleton modelSkeleton) {
        Vector3f vec1 = new Vector3f(0, -1, 0).normalizeLocal();
        modelSkeleton.updateWorldVectors();
        Vector3f vec2 = modelSkeleton.getBone("左手首").getModelSpacePosition().subtract(modelSkeleton.getBone("左腕").getModelSpacePosition()).normalizeLocal();
        Vector3f vec3 = vec1.cross(vec2).normalizeLocal();
        System.out.println("左ひじ = " + modelSkeleton.getBone("左ひじ").getModelSpacePosition());
        System.out.println("左腕 = " + modelSkeleton.getBone("左腕").getModelSpacePosition());
        System.out.println("vec2 = " + vec2 + " vec3 = " + vec3);
        float angle = vec1.angleBetween(vec2);
        System.out.println("angile = " + angle + " vector = " + vec3);
        Quaternion q = new Quaternion();
        q.fromAngleAxis(angle, vec3);
//        q = modelSkeleton.getBone("左腕").getModelSpaceRotation().inverse().multLocal(q);
        return q;
    }

    void updateCenter() {
        TempVars temp = TempVars.get();
        try {
            convOrientation(skeleton.getSkeletonJointOrientation(userId, SkeletonJoint.TORSO), temp.quat1);
            Bone bone = pmdNode.getSkeleton().getBone("センター");
//            bone.getLocalRotation().loadIdentity();
//            bone.updateWorldVectors();
//            modelSkeleton.updateWorldVectors();
//            temp.quat2.set(bone.getParent().getModelSpaceRotation());
//            temp.quat2.inverseLocal();
//            temp.quat1.multLocal(temp.quat2);
            bone.getLocalRotation().set(temp.quat1);

            pmdNode.getSkeleton().updateWorldVectors();
//            System.out.println("q = "+tmpQ2);
        } catch (StatusException ex) {
            throw new RuntimeException(ex);
        } finally {
            temp.release();
        }
    }

    void updateLeftUde() {
        TempVars temp = TempVars.get();
        try {
            convOrientation(skeleton.getSkeletonJointOrientation(userId, SkeletonJoint.LEFT_SHOULDER), temp.quat1);
//            temp.quat1.multLocal(leftRot);
            Bone bone = pmdNode.getSkeleton().getBone("左腕");
            bone.getLocalRotation().loadIdentity();
//            bone.updateWorldVectors();
            Bone bone2 = pmdNode.getSkeleton().getBone("左ひじ");
            bone2.getLocalRotation().loadIdentity();
//            bone2.updateWorldVectors();
            modelSkeleton.updateWorldVectors();
            Vector3f fromWorldVec = bone2.getModelSpacePosition().subtract(bone.getModelSpacePosition(), temp.vect1).normalizeLocal();
            temp.vect2.set(1f, 0f, 0f);
            Vector3f toWorldVec = temp.quat1.multLocal(temp.vect2);
            float f[] = new float[3];
            temp.quat1.toAngles(f);
//            System.out.println("froVec = "+fromWorldVec+" toVec = "+toWorldVec+" "+f[0]+" "+f[1]+" "+f[2]);

            Quaternion worldRot = calcRot(fromWorldVec, toWorldVec, temp.quat2);
            convRot(worldRot, bone.getModelSpaceRotation(), bone.getLocalRotation());
//            System.out.println("quat1 = "+temp.quat1+" quate2 = "+temp.quat2);
            pmdNode.getSkeleton().updateWorldVectors();
//            System.out.println("q = "+temp.quat1+" after "+bone.getModelSpaceRotation());
        } catch (StatusException ex) {
            throw new RuntimeException(ex);
        } finally {
            temp.release();
        }
    }

    void updateLeftElbow2() {
        TempVars temp = TempVars.get();
        try {
            Point3D pos1 = skeleton.getSkeletonJointPosition(userId, SkeletonJoint.LEFT_ELBOW).getPosition();
            Point3D pos2 = skeleton.getSkeletonJointPosition(userId, SkeletonJoint.LEFT_HAND).getPosition();
            Vector3f toWorldVec = temp.vect2;
            toWorldVec.set(pos2.getX() - pos1.getX(), pos2.getY() - pos1.getY(), pos2.getZ() - pos1.getZ());
            toWorldVec.multLocal(-1, 1, -1);
            toWorldVec.normalizeLocal();

            //            temp.quat1.multLocal(leftRot);
            Bone bone = pmdNode.getSkeleton().getBone("左ひじ");
            bone.getLocalRotation().loadIdentity();
//            bone.updateWorldVectors();
            Bone bone2 = pmdNode.getSkeleton().getBone("左手首");
            bone2.getLocalRotation().loadIdentity();
//            bone2.updateWorldVectors();
            modelSkeleton.updateWorldVectors();
            Vector3f fromWorldVec = bone2.getModelSpacePosition().subtract(bone.getModelSpacePosition(), temp.vect1).normalizeLocal();

            Quaternion worldRot = calcRot(fromWorldVec, toWorldVec, temp.quat2);
            convRot(worldRot, bone.getModelSpaceRotation(), bone.getLocalRotation());
//            System.out.println("quat1 = "+temp.quat1+" quate2 = "+temp.quat2);
            pmdNode.getSkeleton().updateWorldVectors();
//            System.out.println("q = "+temp.quat1+" after "+bone.getModelSpaceRotation());
        } catch (StatusException ex) {
            throw new RuntimeException(ex);
        } finally {
            temp.release();
        }
    }

    void updateLeftElbow() {
        TempVars temp = TempVars.get();
        try {
            convOrientation(skeleton.getSkeletonJointOrientation(userId, SkeletonJoint.LEFT_ELBOW), temp.quat1);
            temp.quat1.multLocal(leftRot);
            Bone bone = pmdNode.getSkeleton().getBone("左ひじ");
            bone.getLocalRotation().loadIdentity();
            bone.updateWorldVectors();
            modelSkeleton.updateWorldVectors();
            convRot(temp.quat1, bone.getParent().getModelSpaceRotation(), temp.quat2);
            bone.getLocalRotation().set(temp.quat2);

            pmdNode.getSkeleton().updateWorldVectors();
//            System.out.println("q = "+tmpQ2);
        } catch (StatusException ex) {
            throw new RuntimeException(ex);
        } finally {
            temp.release();
        }
    }

    void hoge() {
        try {
            skeleton.getSkeletonJointOrientation(userId, SkeletonJoint.HEAD);
        } catch (StatusException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void controlUpdate(float tpf) {
        updateCenter();
//        updateLeftUde();
//        updateLeftElbow();
//        hoge();
        updateBoneRotation(modelSkeleton.getBone("下半身"), SkeletonJoint.WAIST);
        updateBoneRotation(modelSkeleton.getBone("首"), SkeletonJoint.NECK);
        
        updateBone(modelSkeleton.getBone("左腕"), modelSkeleton.getBone("左ひじ"), SkeletonJoint.LEFT_SHOULDER, SkeletonJoint.LEFT_ELBOW);
        updateBone(modelSkeleton.getBone("左ひじ"), modelSkeleton.getBone("左手首"), SkeletonJoint.LEFT_ELBOW, SkeletonJoint.LEFT_HAND);
        updateBone(modelSkeleton.getBone("右腕"), modelSkeleton.getBone("右ひじ"), SkeletonJoint.RIGHT_SHOULDER, SkeletonJoint.RIGHT_ELBOW);
        updateBone(modelSkeleton.getBone("右ひじ"), modelSkeleton.getBone("右手首"), SkeletonJoint.RIGHT_ELBOW, SkeletonJoint.RIGHT_HAND);

        updateBoneRotation(modelSkeleton.getBone("左足"), SkeletonJoint.LEFT_HIP);
        updateBoneRotation(modelSkeleton.getBone("左ひざ"), SkeletonJoint.LEFT_KNEE);
        updateBoneRotation(modelSkeleton.getBone("左足首"), SkeletonJoint.LEFT_FOOT);

        updateBoneRotation(modelSkeleton.getBone("右足"), SkeletonJoint.RIGHT_HIP);
        updateBoneRotation(modelSkeleton.getBone("右ひざ"), SkeletonJoint.RIGHT_KNEE);
        updateBoneRotation(modelSkeleton.getBone("右足首"), SkeletonJoint.RIGHT_FOOT);
        physicsControl.getWorld().updateKinematicPos();
        physicsControl.update(tpf);
        physicsControl.getWorld().applyResultToBone();
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    @Override
    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        pmdNode = (PMDNode) spatial;
        modelSkeleton = pmdNode.getSkeleton();
        initModelSkeleton();
        physicsControl = new PhysicsControl(pmdNode);
        for(int i=pmdNode.getSkeleton().getBoneCount()-1;i>=0;i--) {
            Bone bone = pmdNode.getSkeleton().getBone(i);
            bone.setUserControl(true);
        }
    }

    void initModelSkeleton() {
        leftRot = calcLeftShoulderInitialRotation(modelSkeleton);
    }
    static final EnumMap<SkeletonJoint, String> boneConvMap = new EnumMap<>(SkeletonJoint.class);

    static {
        boneConvMap.put(SkeletonJoint.HEAD, "頭");
        boneConvMap.put(SkeletonJoint.NECK, "首");
        boneConvMap.put(SkeletonJoint.LEFT_SHOULDER, "左腕");
        boneConvMap.put(SkeletonJoint.LEFT_ELBOW, "左ひじ");
        boneConvMap.put(SkeletonJoint.LEFT_HAND, "左手首");
        boneConvMap.put(SkeletonJoint.RIGHT_SHOULDER, "右腕");
        boneConvMap.put(SkeletonJoint.RIGHT_ELBOW, "右ひじ");
        boneConvMap.put(SkeletonJoint.RIGHT_HAND, "右手首");
        boneConvMap.put(SkeletonJoint.TORSO, "センター");
    }
}
