/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CalibrationProgressEventArgs;
import org.OpenNI.CalibrationProgressStatus;
import org.OpenNI.CalibrationStartEventArgs;
import org.OpenNI.CapabilityBase;
import org.OpenNI.IObservable;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.SkeletonJoint;
import org.OpenNI.SkeletonJointOrientation;
import org.OpenNI.SkeletonJointPosition;
import org.OpenNI.SkeletonJointTransformation;
import org.OpenNI.SkeletonProfile;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class SkeletonCapability
extends CapabilityBase {
    private StateChangedObservable jointConfigurationChangeEvent = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToJointConfigurationChange(SkeletonCapability.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromJointConfigurationChange(SkeletonCapability.this.toNative(), hCallback);
        }
    };
    private Observable<CalibrationStartEventArgs> calibrationStartEvent = new Observable<CalibrationStartEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToCalibrationStart(SkeletonCapability.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromCalibrationStart(SkeletonCapability.this.toNative(), hCallback);
        }

        public void callback(int user) {
            this.notify(new CalibrationStartEventArgs(user));
        }
    };
    private Observable<CalibrationProgressEventArgs> calibrationInProgressEvent = new Observable<CalibrationProgressEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToCalibrationInProgress(SkeletonCapability.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromCalibrationInProgress(SkeletonCapability.this.toNative(), hCallback);
        }

        public void callback(int user, int state) {
            this.notify(new CalibrationProgressEventArgs(user, CalibrationProgressStatus.fromNative(state)));
        }
    };
    private Observable<CalibrationProgressEventArgs> calibrationCompleteEvent = new Observable<CalibrationProgressEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToCalibrationComplete(SkeletonCapability.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromCalibrationComplete(SkeletonCapability.this.toNative(), hCallback);
        }

        public void callback(int user, int state) {
            this.notify(new CalibrationProgressEventArgs(user, CalibrationProgressStatus.fromNative(state)));
        }
    };

    public SkeletonCapability(ProductionNode node) throws StatusException {
        super(node);
    }

    public boolean isJointAvailable(SkeletonJoint joint) {
        return NativeMethods.xnIsJointAvailable(this.toNative(), joint.toNative());
    }

    public boolean isProfileAvailable(SkeletonProfile profile) {
        return NativeMethods.xnIsProfileAvailable(this.toNative(), profile.toNative());
    }

    public void setSkeletonProfile(SkeletonProfile profile) throws StatusException {
        int status = NativeMethods.xnSetSkeletonProfile(this.toNative(), profile.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void setJointActive(SkeletonJoint joint, boolean active) throws StatusException {
        int status = NativeMethods.xnSetJointActive(this.toNative(), joint.toNative(), active);
        WrapperUtils.throwOnError(status);
    }

    public boolean isJointActive(SkeletonJoint joint) {
        return NativeMethods.xnIsJointActive(this.toNative(), joint.toNative());
    }

    public SkeletonJoint[] enumerateActiveJoints() throws StatusException {
        OutArg<Integer[]> nativeJoints = new OutArg<Integer[]>();
        int status = NativeMethods.xnEnumerateActiveJoints(this.toNative(), nativeJoints);
        WrapperUtils.throwOnError(status);
        SkeletonJoint[] joints = new SkeletonJoint[((Integer[])nativeJoints.value).length];
        for (int i = 0; i < ((Integer[])nativeJoints.value).length; ++i) {
            joints[i] = SkeletonJoint.fromNative(((Integer[])nativeJoints.value)[i]);
        }
        return joints;
    }

    public SkeletonJointTransformation getSkeletonJoint(int user, SkeletonJoint joint) throws StatusException {
        OutArg<SkeletonJointTransformation> transformation = new OutArg<SkeletonJointTransformation>();
        int status = NativeMethods.xnGetSkeletonJoint(this.toNative(), user, joint.toNative(), transformation);
        WrapperUtils.throwOnError(status);
        return (SkeletonJointTransformation)transformation.value;
    }

    public SkeletonJointPosition getSkeletonJointPosition(int user, SkeletonJoint joint) throws StatusException {
        OutArg<SkeletonJointPosition> position = new OutArg<SkeletonJointPosition>();
        int status = NativeMethods.xnGetSkeletonJointPosition(this.toNative(), user, joint.toNative(), position);
        WrapperUtils.throwOnError(status);
        return (SkeletonJointPosition)position.value;
    }

    public SkeletonJointOrientation getSkeletonJointOrientation(int user, SkeletonJoint joint) throws StatusException {
        OutArg<SkeletonJointOrientation> orientation = new OutArg<SkeletonJointOrientation>();
        int status = NativeMethods.xnGetSkeletonJointOrientation(this.toNative(), user, joint.toNative(), orientation);
        WrapperUtils.throwOnError(status);
        return (SkeletonJointOrientation)orientation.value;
    }

    public boolean isSkeletonTracking(int user) {
        return NativeMethods.xnIsSkeletonTracking(this.toNative(), user);
    }

    public boolean isSkeletonCalibrated(int user) {
        return NativeMethods.xnIsSkeletonCalibrated(this.toNative(), user);
    }

    public boolean isSkeletonCalibrating(int user) {
        return NativeMethods.xnIsSkeletonCalibrating(this.toNative(), user);
    }

    public void requestSkeletonCalibration(int user, boolean force) throws StatusException {
        int status = NativeMethods.xnRequestSkeletonCalibration(this.toNative(), user, force);
        WrapperUtils.throwOnError(status);
    }

    public void requestSkeletonCalibration(int user) throws StatusException {
        this.requestSkeletonCalibration(user, false);
    }

    public void abortSkeletonCalibration(int user) throws StatusException {
        int status = NativeMethods.xnAbortSkeletonCalibration(this.toNative(), user);
        WrapperUtils.throwOnError(status);
    }

    public void saveSkeletonCalibrationDataToFile(int user, String fileName) throws StatusException {
        int status = NativeMethods.xnSaveSkeletonCalibrationDataToFile(this.toNative(), user, fileName);
        WrapperUtils.throwOnError(status);
    }

    public void loadSkeletonCalibrationDatadFromFile(int user, String fileName) throws StatusException {
        int status = NativeMethods.xnLoadSkeletonCalibrationDataFromFile(this.toNative(), user, fileName);
        WrapperUtils.throwOnError(status);
    }

    public void saveSkeletonCalibrationData(int user, int slot) throws StatusException {
        int status = NativeMethods.xnSaveSkeletonCalibrationData(this.toNative(), user, slot);
        WrapperUtils.throwOnError(status);
    }

    public void loadSkeletonCalibrationData(int user, int slot) throws StatusException {
        int status = NativeMethods.xnLoadSkeletonCalibrationData(this.toNative(), user, slot);
        WrapperUtils.throwOnError(status);
    }

    public void clearSkeletonCalibrationData(int slot) throws StatusException {
        int status = NativeMethods.xnClearSkeletonCalibrationData(this.toNative(), slot);
        WrapperUtils.throwOnError(status);
    }

    public boolean isSkeletonCalibrationData(int slot) {
        return NativeMethods.xnIsSkeletonCalibrationData(this.toNative(), slot);
    }

    public void startTracking(int user) throws StatusException {
        int status = NativeMethods.xnStartSkeletonTracking(this.toNative(), user);
        WrapperUtils.throwOnError(status);
    }

    public void stopTracking(int user) throws StatusException {
        int status = NativeMethods.xnStopSkeletonTracking(this.toNative(), user);
        WrapperUtils.throwOnError(status);
    }

    public void reset(int user) throws StatusException {
        int status = NativeMethods.xnResetSkeleton(this.toNative(), user);
        WrapperUtils.throwOnError(status);
    }

    public boolean needPoseForCalibration() {
        return NativeMethods.xnNeedPoseForSkeletonCalibration(this.toNative());
    }

    public String getSkeletonCalibrationPose() throws StatusException {
        OutArg<String> pose = new OutArg<String>();
        int status = NativeMethods.xnGetSkeletonCalibrationPose(this.toNative(), pose);
        WrapperUtils.throwOnError(status);
        return (String)pose.value;
    }

    public void setSmoothing(float factor) throws StatusException {
        int status = NativeMethods.xnSetSkeletonSmoothing(this.toNative(), factor);
        WrapperUtils.throwOnError(status);
    }

    public IStateChangedObservable getJointConfigurationChangeEvent() {
        return this.jointConfigurationChangeEvent;
    }

    public IObservable<CalibrationStartEventArgs> getCalibrationStartEvent() {
        return this.calibrationStartEvent;
    }

    public IObservable<CalibrationProgressEventArgs> getCalibrationInProgressEvent() {
        return this.calibrationInProgressEvent;
    }

    public IObservable<CalibrationProgressEventArgs> getCalibrationCompleteEvent() {
        return this.calibrationCompleteEvent;
    }
}

