/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.AlternativeViewpointCapability;
import org.OpenNI.Context;
import org.OpenNI.FrameSyncCapability;
import org.OpenNI.GeneralException;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.MirrorCapability;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class Generator
extends ProductionNode {
    private StateChangedObservable generationRunningChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToGenerationRunningChange(Generator.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromGenerationRunningChange(Generator.this.toNative(), hCallback);
        }
    };
    private StateChangedObservable newDataAvailable = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToNewDataAvailable(Generator.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromNewDataAvailable(Generator.this.toNative(), hCallback);
        }
    };

    Generator(Context context, long nodeHandle, boolean addRef) throws GeneralException {
        super(context, nodeHandle, addRef);
    }

    public void startGenerating() throws StatusException {
        int status = NativeMethods.xnStartGenerating(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public boolean isGenerating() {
        return NativeMethods.xnIsGenerating(this.toNative());
    }

    public void stopGenerating() throws StatusException {
        int status = NativeMethods.xnStopGenerating(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public IStateChangedObservable getGenerationRunningChangedEvent() {
        return this.generationRunningChanged;
    }

    public boolean isNewDataAvailable() {
        OutArg<Long> timestamp = new OutArg<Long>();
        return NativeMethods.xnIsNewDataAvailable(this.toNative(), timestamp);
    }

    public long getAvailableTimestamp() {
        OutArg<Long> timestamp = new OutArg<Long>();
        NativeMethods.xnIsNewDataAvailable(this.toNative(), timestamp);
        return (Long)timestamp.value;
    }

    public IStateChangedObservable getNewDataAvailableEvent() {
        return this.newDataAvailable;
    }

    public void waitAndUpdateData() throws StatusException {
        int status = NativeMethods.xnWaitAndUpdateData(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public boolean isDataNew() {
        return NativeMethods.xnIsDataNew(this.toNative());
    }

    public int getDataSize() {
        return NativeMethods.xnGetDataSize(this.toNative());
    }

    public long getTimestamp() {
        return NativeMethods.xnGetTimestamp(this.toNative());
    }

    public int getFrameID() {
        return NativeMethods.xnGetFrameID(this.toNative());
    }

    public MirrorCapability getMirrorCapability() throws StatusException {
        return new MirrorCapability(this);
    }

    public AlternativeViewpointCapability getAlternativeViewpointCapability() throws StatusException {
        return new AlternativeViewpointCapability(this);
    }

    public FrameSyncCapability getFrameSyncCapability() throws StatusException {
        return new FrameSyncCapability(this);
    }
}

