/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Capability;
import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class GeneralIntCapability
extends CapabilityBase {
    private StateChangedObservable valueChanged;
    private final String capName;
    private int min;
    private int max;
    private int step;
    private int defaultVal;
    private boolean autoSupported;

    public GeneralIntCapability(ProductionNode node, Capability capName) throws StatusException {
        super(node);
        this.capName = capName.getName();
        OutArg<Integer> pMin = new OutArg<Integer>();
        OutArg<Integer> pMax = new OutArg<Integer>();
        OutArg<Integer> pStep = new OutArg<Integer>();
        OutArg<Integer> pDefault = new OutArg<Integer>();
        OutArg<Boolean> pAutoSupported = new OutArg<Boolean>();
        int status = NativeMethods.xnGetGeneralIntRange(this.toNative(), this.getCapName(), pMin, pMax, pStep, pDefault, pAutoSupported);
        WrapperUtils.throwOnError(status);
        this.min = (Integer)pMin.value;
        this.max = (Integer)pMax.value;
        this.step = (Integer)pStep.value;
        this.defaultVal = (Integer)pDefault.value;
        this.autoSupported = (Boolean)pAutoSupported.value;
        this.valueChanged = new StateChangedObservable(){

            @Override
            protected int registerNative(String cb, OutArg<Long> phCallback) {
                return NativeMethods.xnRegisterToGeneralIntValueChange(GeneralIntCapability.this.toNative(), GeneralIntCapability.this.getCapName(), this, cb, phCallback);
            }

            @Override
            protected void unregisterNative(long hCallback) {
                NativeMethods.xnUnregisterFromNodeErrorStateChange(GeneralIntCapability.this.toNative(), hCallback);
            }
        };
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getStep() {
        return this.step;
    }

    public int getDefault() {
        return this.defaultVal;
    }

    public boolean isAutoSupported() {
        return this.autoSupported;
    }

    public int getValue() throws StatusException {
        OutArg<Integer> val = new OutArg<Integer>();
        int status = NativeMethods.xnGetGeneralIntValue(this.toNative(), this.capName, val);
        WrapperUtils.throwOnError(status);
        return (Integer)val.value;
    }

    public void setValue(int value) throws StatusException {
        int status = NativeMethods.xnSetGeneralIntValue(this.toNative(), this.capName, value);
        WrapperUtils.throwOnError(status);
    }

    public IStateChangedObservable getValueChangedEvent() {
        return this.valueChanged;
    }

    String getCapName() {
        return this.capName;
    }
}

