/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.DeviceIdentificationCapability;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.Query;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class Device
extends ProductionNode {
    public Device(Context context, long nodeHandle, boolean addRef) throws StatusException {
        super(context, nodeHandle, addRef);
    }

    public static Device create(Context context, Query query, EnumerationErrors errors) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateDevice(context.toNative(), handle, query == null ? 0L : query.toNative(), errors == null ? 0L : errors.toNative());
        WrapperUtils.throwOnError(status);
        Device result = (Device)context.createProductionNodeObject((Long)handle.value, NodeType.DEVICE);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public static Device create(Context context, Query query) throws GeneralException {
        return Device.create(context, query, null);
    }

    public static Device create(Context context) throws GeneralException {
        return Device.create(context, null, null);
    }

    public DeviceIdentificationCapability getDeviceIdentificationCapability() throws StatusException {
        return new DeviceIdentificationCapability(this);
    }
}

