/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CodecID;
import org.OpenNI.Context;
import org.OpenNI.GeneralException;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class Codec
extends ProductionNode {
    Codec(Context context, long nodeHandle, boolean addRef) throws StatusException {
        super(context, nodeHandle, addRef);
    }

    public static Codec create(Context context, CodecID codecID, ProductionNode initializer) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateCodec(context.toNative(), codecID.toNative(), initializer.toNative(), handle);
        WrapperUtils.throwOnError(status);
        Codec result = (Codec)context.createProductionNodeObject((Long)handle.value, NodeType.CODEC);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public CodecID getCodecID() {
        int codecID = NativeMethods.xnGetCodecID(this.toNative());
        return new CodecID(codecID);
    }

    public int EncodeData(long pSrcPtr, int nSrcSize, long pDstPtr, int nDstSize) throws StatusException {
        OutArg<Integer> written = new OutArg<Integer>();
        int status = NativeMethods.xnEncodeData(this.toNative(), pSrcPtr, nSrcSize, pDstPtr, nDstSize, written);
        WrapperUtils.throwOnError(status);
        return (Integer)written.value;
    }

    public int DecodeData(long pSrcPtr, int nSrcSize, long pDstPtr, int nDstSize) throws StatusException {
        OutArg<Integer> written = new OutArg<Integer>();
        int status = NativeMethods.xnDecodeData(this.toNative(), pSrcPtr, nSrcSize, pDstPtr, nDstSize, written);
        WrapperUtils.throwOnError(status);
        return (Integer)written.value;
    }
}

