package test.android;

import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.PointLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import projectkyoto.jme3.mmd.CartoonEdgeProcessor;
import projectkyoto.jme3.mmd.PMDLoaderGLSLSkinning2;
import projectkyoto.jme3.mmd.PMDNode;
import projectkyoto.jme3.mmd.UpdateControl;
import projectkyoto.jme3.mmd.VMDLoader;
import projectkyoto.jme3.mmd.vmd.VMDControl;
import projectkyoto.jme3.mmd.vmd.VMDControlMT;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.VMDFile;

/**
 * test
 * <p/>
 * @author kobayasi
 */
public class MMDViewer extends SimpleApplication {

    PointLight pl;
    Geometry lightMdl;
    VMDControl vmdControl;
    PMDNode pmdNode;
//    ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(4);

    public static void main(String[] args) {
//        com.jme3.system.JmeSystem.setLowPermissions(true);
        MMDViewer app = new MMDViewer();
        app.start();
    }
    

    @Override
    public void simpleInitApp() {
        settings.put("USE_VA", new Boolean(false));
        setSettings(settings);
        flyCam.setMoveSpeed(50);
        // Load Model
        assetManager.registerLoader(PMDLoaderGLSLSkinning2.class, "pmd");
        assetManager.registerLoader(VMDLoader.class, "vmd");
        pmdNode = (PMDNode) assetManager.loadModel("/Model/初音ミク.pmd");
        pmdNode.setGlslSkinning(true);
//        PMDNode pmdNode = new PMDNode("初音ミク", pmdModel, assetManager);
        VMDFile vmd = (VMDFile) assetManager.loadAsset("/motion/ごまえミク.vmd");
//        VMDControlMT vmdControlMT = new VMDControlMT(pool, pmdNode, vmd);
//        vmdControl = vmdControlMT.getCallable().getVmdControl();
//        pmdNode.addControl(vmdControlMT);
        vmdControl = new VMDControl(pmdNode, vmd);
        pmdNode.addControl(vmdControl);
        vmdControl.setFrameNo(0);
        vmdControl.setPause(true);
        vmdControl.getPhysicsControl().getWorld().setAccuracy(1 / 120f);
        vmdControl.setPause(false);
        pmdNode.update();
        pmdNode.addControl(new UpdateControl(pmdNode));

        rootNode.attachChild(pmdNode);


        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1, 0, -5).normalizeLocal());
        dl.setColor(ColorRGBA.White.mult(0.5f));
        rootNode.addLight(dl);
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(1.0f));
        rootNode.addLight(al);
        CartoonEdgeProcessor cartoonEdgeProcess = new CartoonEdgeProcessor();
        viewPort.addProcessor(cartoonEdgeProcess);

        cam.setLocation(new Vector3f(0, 10, 40));
        renderer.setBackgroundColor(ColorRGBA.Gray);
    }
    float time = 0;

    @Override
    public void simpleUpdate(float tpf) {
        time += tpf;
        if (time > 5) {
            // start after 5 seconds.
            if (vmdControl != null && vmdControl.isPause()) {
            }
        }
    }

    @Override
    public void destroy() {
//        pool.shutdown();
    }
    
}
