/*
 * Decompiled with CFR 0.152.
 */
package org.novyon.noise;

import org.novyon.noise.ShaderUtils;

public class Color {
    private final float[] rgba = new float[4];

    public Color() {
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.rgba[0] = (float)(r & 0xFF) / 256.0f;
        this.rgba[1] = (float)(g & 0xFF) / 256.0f;
        this.rgba[2] = (float)(b & 0xFF) / 256.0f;
        this.rgba[3] = (float)(a & 0xFF) / 256.0f;
    }

    public Color(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color(float r, float g, float b, float a) {
        this.rgba[0] = ShaderUtils.clamp(r, 0.0f, 1.0f);
        this.rgba[1] = ShaderUtils.clamp(g, 0.0f, 1.0f);
        this.rgba[2] = ShaderUtils.clamp(b, 0.0f, 1.0f);
        this.rgba[3] = ShaderUtils.clamp(a, 0.0f, 1.0f);
    }

    public Color(int h, float s, float b) {
        this(h, s, b, 1.0f);
    }

    public Color(int h, float s, float b, float a) {
        this.rgba[3] = a;
        if (s == 0.0f) {
            this.rgba[0] = b;
            this.rgba[1] = b;
            this.rgba[2] = b;
            return;
        }
        float hh = (float)h / 60.0f;
        int i = ShaderUtils.floor(hh);
        float f = hh - (float)i;
        float p = b * (1.0f - s);
        float q = b * (1.0f - s * f);
        float t = b * (1.0f - s * (1.0f - f));
        if (i == 0) {
            this.rgba[0] = b;
            this.rgba[1] = t;
            this.rgba[2] = p;
        } else if (i == 1) {
            this.rgba[0] = q;
            this.rgba[1] = b;
            this.rgba[2] = p;
        } else if (i == 2) {
            this.rgba[0] = p;
            this.rgba[1] = b;
            this.rgba[2] = t;
        } else if (i == 3) {
            this.rgba[0] = p;
            this.rgba[1] = q;
            this.rgba[2] = b;
        } else if (i == 4) {
            this.rgba[0] = t;
            this.rgba[1] = p;
            this.rgba[2] = b;
        } else {
            this.rgba[0] = b;
            this.rgba[1] = p;
            this.rgba[2] = q;
        }
    }

    public int toInteger() {
        return 0 | (int)(this.rgba[3] * 256.0f) << 24 | (int)(this.rgba[0] * 256.0f) << 16 | (int)(this.rgba[1] * 256.0f) << 8 | (int)(this.rgba[2] * 256.0f);
    }

    public String toWeb() {
        return Integer.toHexString(this.toInteger());
    }

    public Color toGrayscale() {
        float v = (this.rgba[0] + this.rgba[1] + this.rgba[2]) / 3.0f;
        return new Color(v, v, v, this.rgba[3]);
    }

    public Color toSepia() {
        float r = ShaderUtils.clamp(this.rgba[0] * 0.393f + this.rgba[1] * 0.769f + this.rgba[2] * 0.189f, 0.0f, 1.0f);
        float g = ShaderUtils.clamp(this.rgba[0] * 0.349f + this.rgba[1] * 0.686f + this.rgba[2] * 0.168f, 0.0f, 1.0f);
        float b = ShaderUtils.clamp(this.rgba[0] * 0.272f + this.rgba[1] * 0.534f + this.rgba[2] * 0.131f, 0.0f, 1.0f);
        return new Color(r, g, b, this.rgba[3]);
    }
}

