/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.InvalidPMDFileException;
import projectkyoto.mmd.file.PMDBoneDispList;
import projectkyoto.mmd.file.PMDBoneDispNameList;
import projectkyoto.mmd.file.PMDBoneList;
import projectkyoto.mmd.file.PMDHeaderEnglish;
import projectkyoto.mmd.file.PMDIKList;
import projectkyoto.mmd.file.PMDJointList;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDRigidBodyList;
import projectkyoto.mmd.file.PMDSkinData;
import projectkyoto.mmd.file.PMDSkinDispList;
import projectkyoto.mmd.file.PMDToonTextureList;
import projectkyoto.mmd.file.PMDVertex;

public class PMDModel {
    private String id;
    private float version;
    private String modelName;
    private String comment;
    private int vertCount;
    private PMDVertex[] vertexList;
    private int faceVertCount;
    private int[] faceVertIndex;
    private int materialCount;
    private PMDMaterial[] material;
    private PMDBoneList boneList;
    private PMDIKList ikList;
    private int skinCount;
    private PMDSkinData[] skinData;
    private PMDSkinDispList skinDispList;
    private PMDBoneDispNameList boneDispNameList;
    private PMDBoneDispList boneDispList;
    private PMDHeaderEnglish headerEnglish;
    private PMDToonTextureList toonTextureList;
    private PMDRigidBodyList rigidBodyList;
    private PMDJointList jointList;

    public PMDModel() {
    }

    public PMDModel(URL url) throws IOException {
        this.readFromFile(url.openStream());
    }

    public PMDModel(InputStream is) throws IOException {
        this.readFromFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile(InputStream is) throws IOException {
        FilterInputStream dis = null;
        try {
            dis = new DataInputStreamLittleEndian(new BufferedInputStream(is));
            this.readFromStream((DataInputStreamLittleEndian)dis);
            dis.close();
        }
        finally {
            if (dis != null) {
                dis.close();
                dis = null;
            }
        }
    }

    public void readFromStream(DataInputStreamLittleEndian is) throws IOException {
        int i;
        this.id = is.readString(3);
        if (!"Pmd".equals(this.id)) {
            throw new InvalidPMDFileException("Invalid ID:" + this.id);
        }
        this.version = is.readFloat();
        this.modelName = is.readString(20);
        this.comment = is.readString(256);
        this.vertCount = is.readInt();
        this.vertexList = new PMDVertex[this.vertCount];
        for (i = 0; i < this.vertCount; ++i) {
            this.vertexList[i] = new PMDVertex(is);
        }
        this.faceVertCount = is.readInt();
        this.faceVertIndex = new int[this.faceVertCount];
        for (i = 0; i < this.faceVertCount; ++i) {
            this.faceVertIndex[i] = is.readUnsignedShort();
        }
        for (i = 0; i < this.faceVertCount; i += 3) {
            int tmp = this.faceVertIndex[i];
            this.faceVertIndex[i] = this.faceVertIndex[i + 1];
            this.faceVertIndex[i + 1] = tmp;
        }
        this.materialCount = is.readInt();
        this.material = new PMDMaterial[this.materialCount];
        for (i = 0; i < this.materialCount; ++i) {
            this.material[i] = new PMDMaterial(is);
        }
        this.boneList = new PMDBoneList(is);
        this.ikList = new PMDIKList(is);
        this.skinCount = is.readShort();
        this.skinData = new PMDSkinData[this.skinCount];
        for (i = 0; i < this.skinCount; ++i) {
            this.skinData[i] = new PMDSkinData(is);
        }
        this.skinDispList = new PMDSkinDispList(is);
        this.boneDispNameList = new PMDBoneDispNameList(is);
        this.boneDispList = new PMDBoneDispList(is);
        this.headerEnglish = new PMDHeaderEnglish(this, is);
        this.toonTextureList = new PMDToonTextureList(is);
        this.rigidBodyList = new PMDRigidBodyList(is);
        this.jointList = new PMDJointList(is);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_6;
        StringBuffer sb = new StringBuffer();
        sb.append("{id = " + this.id + " version = " + this.version + " modelName = " + this.modelName + " comment = " + this.comment);
        sb.append(" vertexCount = " + this.vertCount);
        for (PMDVertex pMDVertex : this.vertexList) {
            sb.append(pMDVertex.toString());
        }
        sb.append(" faceVertCount = " + this.faceVertCount);
        sb.append(" faceVertIndex = {");
        for (int n : this.faceVertIndex) {
            sb.append(n).append(" ");
        }
        sb.append("}");
        sb.append(" materialCount = ").append(this.materialCount);
        sb.append(" PMDMaterial = {");
        for (PMDMaterial pMDMaterial : this.material) {
            sb.append(pMDMaterial).append(" ");
        }
        sb.append("}\n");
        sb.append("boneList = ");
        sb.append(this.boneList.toString());
        sb.append("\nikList = " + this.ikList);
        sb.append("\nskinData = {");
        boolean bl = false;
        while (var2_6 < this.skinCount) {
            sb.append(this.skinData[var2_6]);
            sb.append("\n");
            ++var2_6;
        }
        sb.append("}\n}\n");
        sb.append(this.rigidBodyList.toString());
        return sb.toString();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getFaceVertCount() {
        return this.faceVertCount;
    }

    public void setFaceVertCount(int faceVertCount) {
        this.faceVertCount = faceVertCount;
    }

    public int[] getFaceVertIndex() {
        return this.faceVertIndex;
    }

    public void setFaceVertIndex(int[] faceVertIndex) {
        this.faceVertIndex = faceVertIndex;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PMDMaterial[] getMaterial() {
        return this.material;
    }

    public void setMaterial(PMDMaterial[] material) {
        this.material = material;
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public void setMaterialCount(int materialCount) {
        this.materialCount = materialCount;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float version) {
        this.version = version;
    }

    public int getVertCount() {
        return this.vertCount;
    }

    public void setVertCount(int vertCount) {
        this.vertCount = vertCount;
    }

    public PMDVertex[] getVertexList() {
        return this.vertexList;
    }

    public void setVertexList(PMDVertex[] vertexList) {
        this.vertexList = vertexList;
    }

    public PMDBoneList getBoneList() {
        return this.boneList;
    }

    public void setBoneList(PMDBoneList boneList) {
        this.boneList = boneList;
    }

    public int getSkinCount() {
        return this.skinCount;
    }

    public void setSkinCount(int skinCount) {
        this.skinCount = skinCount;
    }

    public PMDSkinData[] getSkinData() {
        return this.skinData;
    }

    public void setSkinData(PMDSkinData[] skinData) {
        this.skinData = skinData;
    }

    public PMDIKList getIkList() {
        return this.ikList;
    }

    public void setIkList(PMDIKList ikList) {
        this.ikList = ikList;
    }

    public PMDBoneDispList getBoneDispList() {
        return this.boneDispList;
    }

    public void setBoneDispList(PMDBoneDispList boneDispList) {
        this.boneDispList = boneDispList;
    }

    public PMDBoneDispNameList getBoneDispNameList() {
        return this.boneDispNameList;
    }

    public void setBoneDispNameList(PMDBoneDispNameList boneDispNameList) {
        this.boneDispNameList = boneDispNameList;
    }

    public PMDHeaderEnglish getHeaderEnglish() {
        return this.headerEnglish;
    }

    public void setHeaderEnglish(PMDHeaderEnglish headerEnglish) {
        this.headerEnglish = headerEnglish;
    }

    public PMDSkinDispList getSkinDispList() {
        return this.skinDispList;
    }

    public void setSkinDispList(PMDSkinDispList skinDispList) {
        this.skinDispList = skinDispList;
    }

    public PMDToonTextureList getToonTextureList() {
        return this.toonTextureList;
    }

    public void setToonTextureList(PMDToonTextureList toonTextureList) {
        this.toonTextureList = toonTextureList;
    }

    public PMDJointList getJointList() {
        return this.jointList;
    }

    public void setJointList(PMDJointList jointList) {
        this.jointList = jointList;
    }

    public PMDRigidBodyList getRigidBodyList() {
        return this.rigidBodyList;
    }

    public void setRigidBodyList(PMDRigidBodyList rigidBodyList) {
        this.rigidBodyList = rigidBodyList;
    }
}

