/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd.vmd;

import projectkyoto.jme3.mmd.vmd.BoneMotionList;

public class IPUtil {
    static float ipfunc(float t, float p1, float p2) {
        return (1.0f + 3.0f * p1 - 3.0f * p2) * t * t * t + (3.0f * p2 - 6.0f * p1) * t * t + 3.0f * p1 * t;
    }

    static float ipfuncd(float t, float p1, float p2) {
        return (3.0f + 9.0f * p1 - 9.0f * p2) * t * t + (6.0f * p2 - 12.0f * p1) * t + 3.0f * p1;
    }

    static float calcIp(BoneMotionList bml, float x, int offset) {
        if (x <= 0.0f) {
            return 0.0f;
        }
        if (x >= 1.0f) {
            return 1.0f;
        }
        int ipTableSize = bml.ipTable[offset].length;
        for (int i = 0; i < ipTableSize; ++i) {
            float y1;
            float x1;
            if (bml.ipTable[offset][i][0] == x) {
                return bml.ipTable[offset][i][1];
            }
            if (!(bml.ipTable[offset][i][0] > x)) continue;
            if (i == 0) {
                x1 = 0.0f;
                y1 = 0.0f;
            } else {
                x1 = bml.ipTable[offset][i - 1][0];
                y1 = bml.ipTable[offset][i - 1][1];
            }
            float x2 = bml.ipTable[offset][i][0];
            float y2 = bml.ipTable[offset][i][1];
            return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
        }
        return 1.0f;
    }

    static void createInterpolationTable(byte[] ip, float[][][] ipTable) {
        for (int i = 0; i < 4; ++i) {
            int d;
            int ipTableSize = ipTable[i].length;
            if (ip[0 + i] == ip[4 + i] && ip[8 + i] == ip[12 + i]) {
                for (d = 0; d < ipTableSize; ++d) {
                    ipTable[i][d][0] = (float)d / (float)ipTableSize;
                    ipTable[i][d][1] = (float)d / (float)ipTableSize;
                }
                continue;
            }
            float x1 = (float)ip[i] / 127.0f;
            float y1 = (float)ip[4 + i] / 127.0f;
            float x2 = (float)ip[8 + i] / 127.0f;
            float y2 = (float)ip[12 + i] / 127.0f;
            for (d = 0; d < ipTableSize; ++d) {
                float inval;
                float t = inval = (float)d / (float)ipTableSize;
                ipTable[i][d][0] = IPUtil.ipfunc(t, x1, x2);
                ipTable[i][d][1] = IPUtil.ipfunc(t, y1, y2);
            }
        }
    }
}

