/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;

public class TargetElementResolver {
    private static final String PARENT = "#parent";
    private Screen screen;
    private Element base;

    public TargetElementResolver(Screen screen, Element baseElement) {
        this.screen = screen;
        this.base = baseElement;
    }

    public Element resolve(String id) {
        if (id == null) {
            return null;
        }
        if (id.startsWith(PARENT)) {
            return this.resolveParents(id, this.base.getParent());
        }
        if (id.startsWith("#")) {
            return this.base.findElementByName(id);
        }
        return this.screen.findElementByName(id);
    }

    private Element resolveParents(String id, Element parent) {
        String subParentId = id.replaceFirst(PARENT, "");
        if (!subParentId.startsWith(PARENT)) {
            if (subParentId.startsWith("#")) {
                return parent.findElementByName(subParentId.replaceFirst("#", ""));
            }
            return parent;
        }
        return this.resolveParents(subParentId, parent.getParent());
    }
}

