/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types.apply;

import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.layout.manager.AbsolutePositionLayout;
import de.lessvoid.nifty.layout.manager.CenterLayout;
import de.lessvoid.nifty.layout.manager.HorizontalLayout;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.layout.manager.OverlayLayout;
import de.lessvoid.nifty.layout.manager.VerticalLayout;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageMode;
import de.lessvoid.nifty.render.image.ImageModeFactory;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;

public class Convert {
    public static final String DEFAULT_PADDING = "0px";
    public static final HorizontalAlign DEFAULT_HORIZONTAL_ALIGN = HorizontalAlign.left;
    public static final VerticalAlign DEFAULT_VERTICAL_ALIGN = VerticalAlign.top;
    public static final HorizontalAlign DEFAULT_TEXT_HORIZONTAL_ALIGN = HorizontalAlign.center;
    public static final VerticalAlign DEFAULT_TEXT_VERTICAL_ALIGN = VerticalAlign.center;
    public static final boolean DEFAULT_IMAGE_FILTER = false;
    public static final boolean DEFAULT_FOCUSABLE = false;
    public static final boolean DEFAULT_VISIBLE_TO_MOUSE = false;
    public static final boolean DEFAULT_VISIBLE = true;
    public static final boolean DEFAULT_CHILD_CLIP = false;
    public static final Color DEFAULT_COLOR = null;

    public RenderFont font(NiftyRenderEngine niftyRenderEngine, String value) {
        if (value == null) {
            return null;
        }
        return niftyRenderEngine.createFont(value);
    }

    public SizeValue sizeValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        return new SizeValue(value);
    }

    public SizeValue paddingSizeValue(String value) {
        if (value == null) {
            return new SizeValue(DEFAULT_PADDING);
        }
        return new SizeValue(value);
    }

    public SizeValue paddingSizeValue(String value, String defaultValue) {
        if (value == null) {
            return new SizeValue(defaultValue);
        }
        return new SizeValue(value);
    }

    public HorizontalAlign horizontalAlign(String value) {
        if (value == null) {
            return DEFAULT_HORIZONTAL_ALIGN;
        }
        return HorizontalAlign.valueOf(value);
    }

    public HorizontalAlign textHorizontalAlign(String value) {
        if (value == null) {
            return DEFAULT_TEXT_HORIZONTAL_ALIGN;
        }
        return HorizontalAlign.valueOf(value);
    }

    public VerticalAlign verticalAlign(String value) {
        if (value == null) {
            return DEFAULT_VERTICAL_ALIGN;
        }
        return VerticalAlign.valueOf(value);
    }

    public VerticalAlign textVerticalAlign(String value) {
        if (value == null) {
            return DEFAULT_TEXT_VERTICAL_ALIGN;
        }
        return VerticalAlign.valueOf(value);
    }

    public LayoutManager layoutManager(String type) {
        if (type == null) {
            return null;
        }
        String typeCompare = type.toLowerCase();
        if (typeCompare.equals("vertical")) {
            return new VerticalLayout();
        }
        if (typeCompare.equals("center")) {
            return new CenterLayout();
        }
        if (typeCompare.equals("horizontal")) {
            return new HorizontalLayout();
        }
        if (typeCompare.equals("overlay")) {
            return new OverlayLayout();
        }
        if (typeCompare.equals("absolute")) {
            return new AbsolutePositionLayout();
        }
        if (typeCompare.equals("absolute-inside")) {
            return new AbsolutePositionLayout(new AbsolutePositionLayout.KeepInsidePostProcess());
        }
        return null;
    }

    public Color color(String value) {
        if (value == null) {
            return DEFAULT_COLOR;
        }
        return new Color(value);
    }

    public ImageMode imageMode(String areaProviderProperty, String renderStrategyProperty) {
        return ImageModeFactory.getSharedInstance().createImageMode(areaProviderProperty, renderStrategyProperty);
    }

    public int insetSizeValue(String value, int imageHeight) {
        if (value == null) {
            return 0;
        }
        SizeValue sizeValue = new SizeValue(value);
        return sizeValue.getValueAsInt(imageHeight);
    }
}

