/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectOnHoverAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectsAttributes;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.loaderv2.types.EffectType;
import de.lessvoid.nifty.loaderv2.types.EffectTypeOnHover;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.StringHelper;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class EffectsType
extends XmlBaseType {
    protected Collection<EffectType> onStartScreen = new ArrayList<EffectType>();
    protected Collection<EffectType> onEndScreen = new ArrayList<EffectType>();
    protected Collection<EffectType> onHover = new ArrayList<EffectType>();
    protected Collection<EffectType> onStartHover = new ArrayList<EffectType>();
    protected Collection<EffectType> onEndHover = new ArrayList<EffectType>();
    protected Collection<EffectType> onClick = new ArrayList<EffectType>();
    protected Collection<EffectType> onFocus = new ArrayList<EffectType>();
    protected Collection<EffectType> onLostFocus = new ArrayList<EffectType>();
    protected Collection<EffectType> onGetFocus = new ArrayList<EffectType>();
    protected Collection<EffectType> onActive = new ArrayList<EffectType>();
    protected Collection<EffectType> onCustom = new ArrayList<EffectType>();
    protected Collection<EffectType> onShow = new ArrayList<EffectType>();
    protected Collection<EffectType> onHide = new ArrayList<EffectType>();
    protected Collection<EffectType> onEnabled = new ArrayList<EffectType>();
    protected Collection<EffectType> onDisabled = new ArrayList<EffectType>();

    public EffectsType() {
    }

    public EffectsType(EffectsType src) {
        super(src);
        this.copyEffects(src);
    }

    public void mergeFromEffectsType(EffectsType src) {
        this.mergeFromAttributes(src.getAttributes());
        this.mergeEffects(src);
    }

    void copyEffects(EffectsType src) {
        this.copyCollection(this.onStartScreen, src.onStartScreen);
        this.copyCollection(this.onEndScreen, src.onEndScreen);
        this.copyCollection(this.onHover, src.onHover);
        this.copyCollection(this.onStartHover, src.onStartHover);
        this.copyCollection(this.onEndHover, src.onEndHover);
        this.copyCollection(this.onClick, src.onClick);
        this.copyCollection(this.onFocus, src.onFocus);
        this.copyCollection(this.onLostFocus, src.onLostFocus);
        this.copyCollection(this.onGetFocus, src.onGetFocus);
        this.copyCollection(this.onActive, src.onActive);
        this.copyCollection(this.onCustom, src.onCustom);
        this.copyCollection(this.onShow, src.onShow);
        this.copyCollection(this.onHide, src.onHide);
        this.copyCollection(this.onEnabled, src.onEnabled);
        this.copyCollection(this.onDisabled, src.onDisabled);
    }

    void mergeEffects(EffectsType src) {
        this.mergeCollection(this.onStartScreen, src.onStartScreen);
        this.mergeCollection(this.onEndScreen, src.onEndScreen);
        this.mergeCollection(this.onHover, src.onHover);
        this.mergeCollection(this.onStartHover, src.onStartHover);
        this.mergeCollection(this.onEndHover, src.onEndHover);
        this.mergeCollection(this.onClick, src.onClick);
        this.mergeCollection(this.onFocus, src.onFocus);
        this.mergeCollection(this.onLostFocus, src.onLostFocus);
        this.mergeCollection(this.onGetFocus, src.onGetFocus);
        this.mergeCollection(this.onActive, src.onActive);
        this.mergeCollection(this.onCustom, src.onCustom);
        this.mergeCollection(this.onShow, src.onShow);
        this.mergeCollection(this.onHide, src.onHide);
        this.mergeCollection(this.onEnabled, src.onEnabled);
        this.mergeCollection(this.onDisabled, src.onDisabled);
    }

    Collection<EffectType> copyCollection(Collection<EffectType> dst, Collection<EffectType> src) {
        dst.clear();
        this.copyEffects(dst, src);
        return dst;
    }

    Collection<EffectType> mergeCollection(Collection<EffectType> dst, Collection<EffectType> src) {
        this.copyEffects(dst, src);
        return dst;
    }

    void copyEffects(Collection<EffectType> dst, Collection<EffectType> src) {
        for (EffectType e : src) {
            dst.add(e.clone());
        }
    }

    @Override
    public void translateSpecialValues(Nifty nifty, Screen screen) {
        super.translateSpecialValues(nifty, screen);
        for (Collection col : new Collection[]{this.onStartScreen, this.onEndScreen, this.onHover, this.onStartHover, this.onEndHover, this.onClick, this.onFocus, this.onLostFocus, this.onGetFocus, this.onActive, this.onCustom, this.onShow, this.onHide, this.onEnabled, this.onDisabled}) {
            for (EffectType e : col) {
                e.translateSpecialValues(nifty, screen);
            }
        }
    }

    public void addOnStartScreen(EffectType effectParam) {
        this.onStartScreen.add(effectParam);
    }

    public void addOnEndScreen(EffectType effectParam) {
        this.onEndScreen.add(effectParam);
    }

    public void addOnHover(EffectTypeOnHover effectParam) {
        this.onHover.add(effectParam);
    }

    public void addOnStartHover(EffectType effectParam) {
        this.onStartHover.add(effectParam);
    }

    public void addOnEndHover(EffectType effectParam) {
        this.onEndHover.add(effectParam);
    }

    public void addOnClick(EffectType effectParam) {
        this.onClick.add(effectParam);
    }

    public void addOnFocus(EffectType effectParam) {
        this.onFocus.add(effectParam);
    }

    public void addOnLostFocus(EffectType effectParam) {
        this.onLostFocus.add(effectParam);
    }

    public void addOnGetFocus(EffectType effectParam) {
        this.onGetFocus.add(effectParam);
    }

    public void addOnActive(EffectType effectParam) {
        this.onActive.add(effectParam);
    }

    public void addOnShow(EffectType effectParam) {
        this.onShow.add(effectParam);
    }

    public void addOnHide(EffectType effectParam) {
        this.onHide.add(effectParam);
    }

    public void addOnCustom(EffectType effectParam) {
        this.onCustom.add(effectParam);
    }

    public void addOnDisabled(EffectType effectParam) {
        this.onDisabled.add(effectParam);
    }

    public void addOnEnabled(EffectType effectParam) {
        this.onEnabled.add(effectParam);
    }

    @Override
    public String output(int offset) {
        return StringHelper.whitespace(offset) + "<effects> (" + this.getAttributes().toString() + ")" + this.getCollectionString("onStartScreen", this.onStartScreen, offset + 1) + this.getCollectionString("onEndScreen", this.onEndScreen, offset + 1) + this.getCollectionString("onHover", this.onHover, offset + 1) + this.getCollectionString("onStartHover", this.onStartHover, offset + 1) + this.getCollectionString("onEndHover", this.onEndHover, offset + 1) + this.getCollectionString("onClick", this.onClick, offset + 1) + this.getCollectionString("onFocus", this.onFocus, offset + 1) + this.getCollectionString("onLostFocus", this.onLostFocus, offset + 1) + this.getCollectionString("onGetFocus", this.onGetFocus, offset + 1) + this.getCollectionString("onActive", this.onActive, offset + 1) + this.getCollectionString("onCustom", this.onCustom, offset + 1) + this.getCollectionString("onShow", this.onShow, offset + 1) + this.getCollectionString("onHide", this.onHide, offset + 1) + this.getCollectionString("onEnabled", this.onEnabled, offset + 1) + this.getCollectionString("onDisabled", this.onDisabled, offset + 1);
    }

    private String getCollectionString(String name, Collection<EffectType> effectCollection, int offset) {
        if (effectCollection.isEmpty()) {
            return "";
        }
        String result = "";
        for (EffectType effect : effectCollection) {
            result = result + "\n" + StringHelper.whitespace(offset) + "<" + name + "> " + effect.output(offset);
            if (effect.getStyleId() == null) continue;
            result = result + " {" + effect.getStyleId() + "}";
        }
        return result;
    }

    public void materialize(Nifty nifty, Element element, Screen screen, LinkedList<Object> controllers) {
        Attributes attributes = this.getAttributes();
        this.initEffect(EffectEventId.onStartScreen, this.onStartScreen, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onEndScreen, this.onEndScreen, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onHover, this.onHover, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onStartHover, this.onStartHover, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onEndHover, this.onEndHover, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onClick, this.onClick, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onFocus, this.onFocus, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onLostFocus, this.onLostFocus, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onGetFocus, this.onGetFocus, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onActive, this.onActive, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onCustom, this.onCustom, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onShow, this.onShow, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onHide, this.onHide, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onEnabled, this.onEnabled, element, nifty, screen, attributes, controllers);
        this.initEffect(EffectEventId.onDisabled, this.onDisabled, element, nifty, screen, attributes, controllers);
    }

    private void initEffect(EffectEventId eventId, Collection<EffectType> effectCollection, Element element, Nifty nifty, Screen screen, Attributes effectsTypeAttributes, LinkedList<Object> controllers) {
        for (EffectType effectType : effectCollection) {
            effectType.materialize(nifty, element, eventId, effectsTypeAttributes, controllers);
        }
    }

    public void refreshFromAttributes(ControlEffectsAttributes effects) {
        effects.refreshEffectsType(this);
    }

    public void apply(EffectsType effects, String styleId) {
        this.applyEffectCollection(this.onStartScreen, effects.onStartScreen, styleId);
        this.applyEffectCollection(this.onEndScreen, effects.onEndScreen, styleId);
        this.applyEffectCollection(this.onHover, effects.onHover, styleId);
        this.applyEffectCollection(this.onStartHover, effects.onStartHover, styleId);
        this.applyEffectCollection(this.onEndHover, effects.onEndHover, styleId);
        this.applyEffectCollection(this.onClick, effects.onClick, styleId);
        this.applyEffectCollection(this.onFocus, effects.onFocus, styleId);
        this.applyEffectCollection(this.onLostFocus, effects.onLostFocus, styleId);
        this.applyEffectCollection(this.onGetFocus, effects.onGetFocus, styleId);
        this.applyEffectCollection(this.onActive, effects.onActive, styleId);
        this.applyEffectCollection(this.onCustom, effects.onCustom, styleId);
        this.applyEffectCollection(this.onShow, effects.onShow, styleId);
        this.applyEffectCollection(this.onHide, effects.onHide, styleId);
        this.applyEffectCollection(this.onEnabled, effects.onEnabled, styleId);
        this.applyEffectCollection(this.onDisabled, effects.onDisabled, styleId);
    }

    void applyEffectCollection(Collection<EffectType> src, Collection<EffectType> dst, String styleId) {
        for (EffectType effectType : src) {
            EffectType copy = effectType.clone();
            copy.setStyleId(styleId);
            dst.add(copy);
        }
    }

    public void resolveParameters(Attributes src) {
        this.resolveParameterCollection(this.onStartScreen, src);
        this.resolveParameterCollection(this.onEndScreen, src);
        this.resolveParameterCollection(this.onHover, src);
        this.resolveParameterCollection(this.onStartHover, src);
        this.resolveParameterCollection(this.onEndHover, src);
        this.resolveParameterCollection(this.onClick, src);
        this.resolveParameterCollection(this.onFocus, src);
        this.resolveParameterCollection(this.onLostFocus, src);
        this.resolveParameterCollection(this.onGetFocus, src);
        this.resolveParameterCollection(this.onActive, src);
        this.resolveParameterCollection(this.onCustom, src);
        this.resolveParameterCollection(this.onShow, src);
        this.resolveParameterCollection(this.onHide, src);
        this.resolveParameterCollection(this.onEnabled, src);
        this.resolveParameterCollection(this.onDisabled, src);
    }

    void resolveParameterCollection(Collection<EffectType> dst, Attributes src) {
        for (EffectType e : dst) {
            e.resolveParameters(src);
        }
    }

    public void removeWithTag(String styleId) {
        this.getAttributes().removeWithTag(styleId);
        this.removeAllEffectsWithStyleId(this.onStartScreen, styleId);
        this.removeAllEffectsWithStyleId(this.onEndScreen, styleId);
        this.removeAllEffectsWithStyleId(this.onHover, styleId);
        this.removeAllEffectsWithStyleId(this.onStartHover, styleId);
        this.removeAllEffectsWithStyleId(this.onEndHover, styleId);
        this.removeAllEffectsWithStyleId(this.onClick, styleId);
        this.removeAllEffectsWithStyleId(this.onFocus, styleId);
        this.removeAllEffectsWithStyleId(this.onLostFocus, styleId);
        this.removeAllEffectsWithStyleId(this.onGetFocus, styleId);
        this.removeAllEffectsWithStyleId(this.onActive, styleId);
        this.removeAllEffectsWithStyleId(this.onCustom, styleId);
        this.removeAllEffectsWithStyleId(this.onShow, styleId);
        this.removeAllEffectsWithStyleId(this.onHide, styleId);
        this.removeAllEffectsWithStyleId(this.onEnabled, styleId);
        this.removeAllEffectsWithStyleId(this.onDisabled, styleId);
    }

    private void removeAllEffectsWithStyleId(Collection<EffectType> source, String styleId) {
        Iterator<EffectType> iter = source.iterator();
        while (iter.hasNext()) {
            EffectType current = iter.next();
            if (!styleId.equals(current.getStyleId())) continue;
            iter.remove();
        }
    }

    Collection<ControlEffectAttributes> convertCopy(Collection<EffectType> src) {
        ArrayList<ControlEffectAttributes> result = new ArrayList<ControlEffectAttributes>();
        for (EffectType e : src) {
            result.add(e.convert());
        }
        return result;
    }

    Collection<ControlEffectOnHoverAttributes> convertCopyHover(Collection<EffectType> src) {
        ArrayList<ControlEffectOnHoverAttributes> result = new ArrayList<ControlEffectOnHoverAttributes>();
        for (EffectType e : src) {
            result.add(((EffectTypeOnHover)e).convert());
        }
        return result;
    }

    public Collection<ControlEffectAttributes> getOnStartScreen() {
        return this.convertCopy(this.onStartScreen);
    }

    public Collection<ControlEffectAttributes> getOnEndScreen() {
        return this.convertCopy(this.onEndScreen);
    }

    public Collection<ControlEffectOnHoverAttributes> getOnHover() {
        return this.convertCopyHover(this.onHover);
    }

    public Collection<ControlEffectOnHoverAttributes> getOnStartHover() {
        return this.convertCopyHover(this.onStartHover);
    }

    public Collection<ControlEffectOnHoverAttributes> getOnEndHover() {
        return this.convertCopyHover(this.onEndHover);
    }

    public Collection<ControlEffectAttributes> getOnClick() {
        return this.convertCopy(this.onClick);
    }

    public Collection<ControlEffectAttributes> getOnFocus() {
        return this.convertCopy(this.onFocus);
    }

    public Collection<ControlEffectAttributes> getLostFocus() {
        return this.convertCopy(this.onLostFocus);
    }

    public Collection<ControlEffectAttributes> getOnGetFocus() {
        return this.convertCopy(this.onGetFocus);
    }

    public Collection<ControlEffectAttributes> getOnActive() {
        return this.convertCopy(this.onActive);
    }

    public Collection<ControlEffectAttributes> getOnCustom() {
        return this.convertCopy(this.onCustom);
    }

    public Collection<ControlEffectAttributes> getOnShow() {
        return this.convertCopy(this.onShow);
    }

    public Collection<ControlEffectAttributes> getOnHide() {
        return this.convertCopy(this.onHide);
    }
}

