/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout.manager;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;

public class VerticalLayout
implements LayoutManager {
    @Override
    public void layoutElements(LayoutPart root, List<LayoutPart> children) {
        if (this.isInvalid(root, children)) {
            return;
        }
        int rootBoxX = this.getRootBoxX(root);
        int rootBoxY = this.getRootBoxY(root);
        int rootBoxWidth = this.getRootBoxWidth(root);
        int rootBoxHeight = this.getRootBoxHeight(root);
        int y = rootBoxY;
        for (int i = 0; i < children.size(); ++i) {
            int elementHeight;
            int elementWidth;
            Box currentBox = children.get(i).getBox();
            BoxConstraints currentBoxConstraints = children.get(i).getBoxConstraints();
            if (this.hasHeightConstraint(currentBoxConstraints) && currentBoxConstraints.getHeight().hasWidthSuffix()) {
                elementWidth = this.processWidthConstraints(rootBoxWidth, currentBoxConstraints, 0);
                currentBox.setWidth(elementWidth);
                elementHeight = this.calcElementHeight(children, rootBoxHeight, currentBoxConstraints, elementWidth);
                currentBox.setHeight(elementHeight);
            } else if (this.hasWidthConstraint(currentBoxConstraints) && currentBoxConstraints.getWidth().hasHeightSuffix()) {
                elementHeight = this.calcElementHeight(children, rootBoxHeight, currentBoxConstraints, 0);
                currentBox.setHeight(elementHeight);
                elementWidth = this.processWidthConstraints(rootBoxWidth, currentBoxConstraints, elementHeight);
                currentBox.setWidth(elementWidth);
            } else {
                elementWidth = this.processWidthConstraints(rootBoxWidth, currentBoxConstraints, 0);
                currentBox.setWidth(elementWidth);
                elementHeight = this.calcElementHeight(children, rootBoxHeight, currentBoxConstraints, 0);
                currentBox.setHeight(elementHeight);
            }
            currentBox.setX(this.processHorizontalAlignment(rootBoxX, rootBoxWidth, currentBox.getWidth(), currentBoxConstraints));
            currentBox.setY(y);
            y += elementHeight;
        }
    }

    @Override
    public SizeValue calculateConstraintWidth(LayoutPart root, List<LayoutPart> children) {
        if (children.size() == 0) {
            return null;
        }
        int newWidth = 0;
        for (LayoutPart e : children) {
            newWidth += e.getBoxConstraints().getWidth().getValueAsInt(0.0f);
        }
        newWidth += root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth());
        return new SizeValue((newWidth += root.getBoxConstraints().getPaddingRight().getValueAsInt(root.getBox().getWidth())) + "px");
    }

    @Override
    public SizeValue calculateConstraintHeight(LayoutPart root, List<LayoutPart> children) {
        int newHeight = 0;
        for (LayoutPart e : children) {
            newHeight += e.getBoxConstraints().getHeight().getValueAsInt(0.0f);
        }
        newHeight += root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight());
        return new SizeValue((newHeight += root.getBoxConstraints().getPaddingBottom().getValueAsInt(root.getBox().getHeight())) + "px");
    }

    private int processWidthConstraints(int rootBoxWidth, BoxConstraints constraints, int elementHeight) {
        if (this.hasWidthConstraint(constraints)) {
            if (constraints.getWidth().hasHeightSuffix()) {
                return constraints.getWidth().getValueAsInt(elementHeight);
            }
            return constraints.getWidth().getValueAsInt(rootBoxWidth);
        }
        return rootBoxWidth;
    }

    private int processHorizontalAlignment(int rootBoxX, int rootBoxWidth, int currentBoxWidth, BoxConstraints constraints) {
        if (HorizontalAlign.center.equals((Object)constraints.getHorizontalAlign())) {
            return rootBoxX + (rootBoxWidth - currentBoxWidth) / 2;
        }
        if (HorizontalAlign.right.equals((Object)constraints.getHorizontalAlign())) {
            return rootBoxX + (rootBoxWidth - currentBoxWidth);
        }
        if (HorizontalAlign.left.equals((Object)constraints.getHorizontalAlign())) {
            return rootBoxX;
        }
        return rootBoxX;
    }

    private int calcElementHeight(List<LayoutPart> children, int rootBoxHeight, BoxConstraints boxConstraints, int boxWidth) {
        int h;
        if (this.hasHeightConstraint(boxConstraints) && (h = boxConstraints.getHeight().hasWidthSuffix() ? boxConstraints.getHeight().getValueAsInt(boxWidth) : boxConstraints.getHeight().getValueAsInt(rootBoxHeight)) != -1) {
            return h;
        }
        return this.getMaxNonFixedHeight(children, rootBoxHeight);
    }

    private int getMaxNonFixedHeight(List<LayoutPart> elements, int parentHeight) {
        int maxFixedHeight = 0;
        int fixedCount = 0;
        for (int i = 0; i < elements.size(); ++i) {
            LayoutPart p = elements.get(i);
            BoxConstraints original = p.getBoxConstraints();
            if (!this.hasHeightConstraint(original) || !original.getHeight().isPercentOrPixel()) continue;
            maxFixedHeight = (int)((float)maxFixedHeight + original.getHeight().getValue(parentHeight));
            ++fixedCount;
        }
        int notFixedCount = elements.size() - fixedCount;
        if (notFixedCount > 0) {
            return (parentHeight - maxFixedHeight) / notFixedCount;
        }
        return parentHeight - maxFixedHeight;
    }

    private boolean hasWidthConstraint(BoxConstraints constraints) {
        return constraints != null && constraints.getWidth() != null && !constraints.getWidth().hasWildcard();
    }

    private boolean hasHeightConstraint(BoxConstraints boxConstraints) {
        return boxConstraints != null && boxConstraints.getHeight() != null;
    }

    private boolean isInvalid(LayoutPart root, List<LayoutPart> children) {
        return root == null || children == null || children.size() == 0;
    }

    private int getRootBoxX(LayoutPart root) {
        return root.getBox().getX() + root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxY(LayoutPart root) {
        return root.getBox().getY() + root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight());
    }

    private int getRootBoxWidth(LayoutPart root) {
        return root.getBox().getWidth() - root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth()) - root.getBoxConstraints().getPaddingRight().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxHeight(LayoutPart root) {
        return root.getBox().getHeight() - root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight()) - root.getBoxConstraints().getPaddingBottom().getValueAsInt(root.getBox().getHeight());
    }
}

