/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.sound.SoundHandle;
import de.lessvoid.nifty.tools.SizeValue;

public class FadeMusic
implements EffectImpl {
    private Nifty nifty;
    private float fromVolume;
    private float toVolume;
    private SoundHandle music;

    @Override
    public void activate(Nifty niftyParam, Element element, EffectProperties parameter) {
        this.nifty = niftyParam;
        this.music = this.nifty.getSoundSystem().getMusic(parameter.getProperty("sound"));
        this.fromVolume = new SizeValue(parameter.getProperty("from", "0%")).getValue(1.0f);
        this.toVolume = new SizeValue(parameter.getProperty("to", "100%")).getValue(1.0f);
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        float volume = normalizedTime * (this.toVolume - this.fromVolume) + this.fromVolume;
        this.music.setVolume(volume);
        this.nifty.getSoundSystem().setMusicVolume(volume);
    }

    @Override
    public void deactivate() {
    }
}

