/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dynamic;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.xml.tools.ClassHelper;
import java.util.logging.Logger;

public class ScreenCreator {
    private Logger log = Logger.getLogger(ScreenCreator.class.getName());
    private String id;
    private ScreenController screenController;
    private String defaultFocusElement;
    private String inputMapping;
    private String inputMappingPre;

    public ScreenCreator(String id) {
        this.id = id;
    }

    public ScreenCreator(String id, ScreenController screenController) {
        this.id = id;
        this.screenController = screenController;
    }

    public void setScreenController(ScreenController screenController) {
        this.screenController = screenController;
    }

    public void setDefaultFocusElement(String defaultFocusElement) {
        this.defaultFocusElement = defaultFocusElement;
    }

    public void setInputMapping(String inputMapping) {
        this.inputMapping = inputMapping;
    }

    public void setInputMappingPre(String inputMappingPre) {
        this.inputMappingPre = inputMappingPre;
    }

    public Screen create(Nifty nifty) {
        Screen screen = this.createScreen(nifty);
        this.addRootElement(nifty, screen);
        this.addDefaultFocusElement(screen);
        this.addInputMapping(screen, this.inputMapping);
        this.addPreInputMapping(screen, this.inputMappingPre);
        nifty.addScreen(this.id, screen);
        return screen;
    }

    private Screen createScreen(Nifty nifty) {
        return new Screen(nifty, this.id, this.screenController, nifty.getTimeProvider());
    }

    private void addRootElement(Nifty nifty, Screen screen) {
        Element rootElement = nifty.getRootLayerFactory().createRootLayer("root", nifty, screen, nifty.getTimeProvider());
        screen.setRootElement(rootElement);
    }

    private void addDefaultFocusElement(Screen screen) {
        screen.setDefaultFocusElement(this.defaultFocusElement);
    }

    private void addInputMapping(Screen screen, String inputMappingClass) {
        if (inputMappingClass != null) {
            NiftyInputMapping inputMapping = ClassHelper.getInstance(inputMappingClass, NiftyInputMapping.class);
            if (!(this.screenController instanceof KeyInputHandler)) {
                this.log.info("class [" + this.screenController + "] tries to use inputMapping [" + inputMappingClass + "] but does not implement [" + KeyInputHandler.class.getName() + "]");
            } else {
                screen.addKeyboardInputHandler(inputMapping, (KeyInputHandler)KeyInputHandler.class.cast(this.screenController));
            }
        }
    }

    private void addPreInputMapping(Screen screen, String inputMappingClass) {
        if (inputMappingClass != null) {
            NiftyInputMapping inputMapping = ClassHelper.getInstance(inputMappingClass, NiftyInputMapping.class);
            if (!(this.screenController instanceof KeyInputHandler)) {
                this.log.info("class [" + this.screenController + "] tries to use inputMapping [" + inputMappingClass + "] but does not implement [" + KeyInputHandler.class.getName() + "]");
            } else {
                screen.addPreKeyboardInputHandler(inputMapping, (KeyInputHandler)KeyInputHandler.class.cast(this.screenController));
            }
        }
    }
}

