/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty;

import de.lessvoid.nifty.Parameterizable;
import java.util.Map;
import java.util.logging.Logger;

public class ParameterizedObjectFactory<T extends Parameterizable> {
    private static Logger log = Logger.getLogger(ParameterizedObjectFactory.class.getName());
    private final Map<String, Class<? extends T>> m_objectNameToClassMapping;
    private final String m_fallbackObjectName;

    public ParameterizedObjectFactory(Map<String, Class<? extends T>> objectNameToClassMapping, String fallbackObjectName) {
        this.m_objectNameToClassMapping = objectNameToClassMapping;
        this.m_fallbackObjectName = fallbackObjectName;
    }

    public T create(String objectDescription) {
        T object;
        try {
            object = this.createInternal(objectDescription);
        }
        catch (IllegalArgumentException e) {
            log.warning(e.getMessage() + " -> Falling back to default " + this.m_fallbackObjectName + ".");
            object = this.createInternal(this.m_fallbackObjectName);
        }
        return object;
    }

    private T createInternal(String objectDescription) {
        T object = this.instanciateObject(objectDescription);
        this.initializeObject(object, objectDescription);
        return object;
    }

    private T instanciateObject(String objectDescription) {
        Class<T> objectClass;
        String objectName = this.m_fallbackObjectName;
        if (objectDescription != null) {
            objectName = objectDescription.split(":")[0];
        }
        if ((objectClass = this.m_objectNameToClassMapping.get(objectName)) == null) {
            throw new IllegalArgumentException("No class found for [" + objectName + "].");
        }
        try {
            return (T)((Parameterizable)objectClass.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class [" + objectClass.getName() + "].", e);
        }
    }

    private void initializeObject(T object, String objectDescription) {
        String[] tokens;
        String objectParameters = null;
        if (objectDescription != null && (tokens = objectDescription.split(":")).length > 1) {
            objectParameters = tokens[1];
        }
        object.setParameters(objectParameters);
    }
}

