/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public interface ListBox<T>
extends NiftyControl {
    public void changeSelectionMode(SelectionMode var1, boolean var2);

    public void setListBoxViewConverter(ListBoxViewConverter<T> var1);

    public void addItem(T var1);

    public void insertItem(T var1, int var2);

    public int itemCount();

    public void clear();

    public void selectItemByIndex(int var1);

    public void selectItem(T var1);

    public void selectNext();

    public void selectPrevious();

    public void deselectItemByIndex(int var1);

    public void deselectItem(T var1);

    public List<T> getSelection();

    public List<Integer> getSelectedIndices();

    public void removeItemByIndex(int var1);

    public void removeItem(T var1);

    public List<T> getItems();

    public void showItem(T var1);

    public void showItemByIndex(int var1);

    public void setFocusItem(T var1);

    public void setFocusItemByIndex(int var1);

    public T getFocusItem();

    public int getFocusItemIndex();

    public void addAllItems(List<T> var1);

    public void removeAllItems(List<T> var1);

    public void sortAllItems();

    public int getDisplayItemCount();

    public void sortAllItems(Comparator<T> var1);

    public void refresh();

    public static class ListBoxViewConverterSimple<T>
    implements ListBoxViewConverter<T> {
        private Logger log = Logger.getLogger(ListBoxViewConverterSimple.class.getName());

        @Override
        public void display(Element element, T item) {
            TextRenderer renderer = (TextRenderer)element.getRenderer(TextRenderer.class);
            if (renderer == null) {
                this.log.warning("you're using the ListBoxViewConverterSimple but there is no TextRenderer on the listBoxElement.You've probably changed the item template but did not provided your own ListBoxViewConverter to the ListBox.");
                return;
            }
            if (item != null) {
                renderer.setText(item.toString());
            } else {
                renderer.setText("");
            }
        }

        @Override
        public int getWidth(Element element, T item) {
            TextRenderer renderer = (TextRenderer)element.getRenderer(TextRenderer.class);
            if (renderer == null) {
                this.log.warning("you're using the ListBoxViewConverterSimple but there is no TextRenderer on the listBoxElement.You've probably changed the item template but did not provided your own ListBoxViewConverter to the ListBox.");
                return 0;
            }
            return ((TextRenderer)element.getRenderer(TextRenderer.class)).getFont().getWidth(item.toString());
        }
    }

    public static interface ListBoxViewConverter<T> {
        public void display(Element var1, T var2);

        public int getWidth(Element var1, T var2);
    }

    public static enum SelectionMode {
        Single,
        Multiple,
        Disabled;

    }
}

