/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.io.IOException;

public class GhostControl
extends PhysicsGhostObject
implements PhysicsControl {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected boolean added = false;
    protected PhysicsSpace space = null;
    protected boolean applyLocal = false;

    public GhostControl() {
    }

    public GhostControl(CollisionShape collisionShape) {
        super(collisionShape);
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyLocal;
    }

    public void setApplyPhysicsLocal(boolean bl) {
        this.applyLocal = bl;
    }

    private Vector3f getSpatialTranslation() {
        if (this.applyLocal) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    private Quaternion getSpatialRotation() {
        if (this.applyLocal) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    public Control cloneForSpatial(Spatial spatial) {
        GhostControl ghostControl = new GhostControl(this.collisionShape);
        ghostControl.setCcdMotionThreshold(this.getCcdMotionThreshold());
        ghostControl.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        ghostControl.setCollideWithGroups(this.getCollideWithGroups());
        ghostControl.setCollisionGroup(this.getCollisionGroup());
        ghostControl.setPhysicsLocation(this.getPhysicsLocation());
        ghostControl.setPhysicsRotation(this.getPhysicsRotationMatrix());
        ghostControl.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        ghostControl.setSpatial(spatial);
        return ghostControl;
    }

    public void setSpatial(Spatial spatial) {
        if (this.getUserObject() == null || this.getUserObject() == this.spatial) {
            this.setUserObject(spatial);
        }
        this.spatial = spatial;
        if (spatial == null) {
            if (this.getUserObject() == spatial) {
                this.setUserObject(null);
            }
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.space != null) {
            if (bl && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!bl && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(float f) {
        if (!this.enabled) {
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    public void render(RenderManager renderManager, ViewPort viewPort) {
        if (this.enabled && this.space != null && this.space.getDebugManager() != null) {
            if (this.debugShape == null) {
                this.attachDebugShape(this.space.getDebugManager());
            }
            this.debugShape.setLocalTranslation(this.spatial.getWorldTranslation());
            this.debugShape.setLocalRotation(this.spatial.getWorldRotation());
            this.debugShape.updateLogicalState(0.0f);
            this.debugShape.updateGeometricState();
            renderManager.renderScene(this.debugShape, viewPort);
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace physicsSpace) {
        if (physicsSpace == null) {
            if (this.space != null) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        } else {
            if (this.space == physicsSpace) {
                return;
            }
            physicsSpace.addCollisionObject(this);
            this.added = true;
        }
        this.space = physicsSpace;
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.enabled, "enabled", true);
        outputCapsule.write(this.applyLocal, "applyLocalPhysics", false);
        outputCapsule.write((Savable)this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.enabled = inputCapsule.readBoolean("enabled", true);
        this.spatial = (Spatial)inputCapsule.readSavable("spatial", null);
        this.applyLocal = inputCapsule.readBoolean("applyLocalPhysics", false);
        this.setUserObject(this.spatial);
    }
}

