/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CollisionShape
implements Savable {
    protected long objectId = 0L;
    protected Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    protected float margin = 0.0f;

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long l) {
        this.objectId = l;
    }

    public void setScale(Vector3f vector3f) {
        this.scale.set(vector3f);
        this.setLocalScaling(this.objectId, vector3f);
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public float getMargin() {
        return this.getMargin(this.objectId);
    }

    private native float getMargin(long var1);

    public void setMargin(float f) {
        this.setMargin(this.objectId, f);
        this.margin = f;
    }

    private native void setLocalScaling(long var1, Vector3f var3);

    private native void setMargin(long var1, float var3);

    public void write(JmeExporter jmeExporter) throws IOException {
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.scale, "scale", (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        outputCapsule.write(this.getMargin(), "margin", 0.0f);
    }

    public void read(JmeImporter jmeImporter) throws IOException {
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.scale = (Vector3f)inputCapsule.readSavable("scale", (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        this.margin = inputCapsule.readFloat("margin", 0.0f);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Finalizing CollisionShape {0}", Long.toHexString(this.objectId));
        this.finalizeNative(this.objectId);
    }

    private native void finalizeNative(long var1);
}

