/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.util.EventObject;

public class PhysicsCollisionEvent
extends EventObject {
    public static final int TYPE_ADDED = 0;
    public static final int TYPE_PROCESSED = 1;
    public static final int TYPE_DESTROYED = 2;
    private int type;
    private PhysicsCollisionObject nodeA;
    private PhysicsCollisionObject nodeB;
    public final Vector3f localPointA;
    public final Vector3f localPointB;
    public final Vector3f positionWorldOnB;
    public final Vector3f positionWorldOnA;
    public final Vector3f normalWorldOnB;
    public float distance1;
    public float combinedFriction;
    public float combinedRestitution;
    public int partId0;
    public int partId1;
    public int index0;
    public int index1;
    public Object userPersistentData;
    public float appliedImpulse;
    public boolean lateralFrictionInitialized;
    public float appliedImpulseLateral1;
    public float appliedImpulseLateral2;
    public int lifeTime;
    public final Vector3f lateralFrictionDir1;
    public final Vector3f lateralFrictionDir2;

    public PhysicsCollisionEvent(int n, PhysicsCollisionObject physicsCollisionObject, PhysicsCollisionObject physicsCollisionObject2) {
        this(n, physicsCollisionObject, physicsCollisionObject2, new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f(), 0.0f, 0.0f, 0.0f, 0, 0, 0, 0, null, 0.0f, false, 0.0f, 0.0f, 0, new Vector3f(), new Vector3f());
    }

    public PhysicsCollisionEvent(int n, PhysicsCollisionObject physicsCollisionObject, PhysicsCollisionObject physicsCollisionObject2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, float f, float f2, float f3, int n2, int n3, int n4, int n5, Object object, float f4, boolean bl, float f5, float f6, int n6, Vector3f vector3f6, Vector3f vector3f7) {
        super(physicsCollisionObject);
        this.type = n;
        this.nodeA = physicsCollisionObject;
        this.nodeB = physicsCollisionObject2;
        this.localPointA = vector3f;
        this.localPointB = vector3f2;
        this.positionWorldOnB = vector3f3;
        this.positionWorldOnA = vector3f4;
        this.normalWorldOnB = vector3f5;
        this.distance1 = f;
        this.combinedFriction = f2;
        this.combinedRestitution = f3;
        this.partId0 = n2;
        this.partId1 = n3;
        this.index0 = n4;
        this.index1 = n5;
        this.userPersistentData = object;
        this.appliedImpulse = f4;
        this.lateralFrictionInitialized = bl;
        this.appliedImpulseLateral1 = f5;
        this.appliedImpulseLateral2 = f6;
        this.lifeTime = n6;
        this.lateralFrictionDir1 = vector3f6;
        this.lateralFrictionDir2 = vector3f7;
    }

    public void clean() {
        this.source = null;
        this.type = 0;
        this.nodeA = null;
        this.nodeB = null;
        this.userPersistentData = null;
    }

    public void refactor(int n, PhysicsCollisionObject physicsCollisionObject, PhysicsCollisionObject physicsCollisionObject2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, float f, float f2, float f3, int n2, int n3, int n4, int n5, Object object, float f4, boolean bl, float f5, float f6, int n6, Vector3f vector3f6, Vector3f vector3f7) {
        this.source = physicsCollisionObject;
        this.type = n;
        this.nodeA = physicsCollisionObject;
        this.nodeB = physicsCollisionObject2;
        this.localPointA.set(vector3f);
        this.localPointB.set(vector3f2);
        this.positionWorldOnB.set(vector3f3);
        this.positionWorldOnA.set(vector3f4);
        this.normalWorldOnB.set(vector3f5);
        this.distance1 = f;
        this.combinedFriction = f2;
        this.combinedRestitution = f3;
        this.partId0 = n2;
        this.partId1 = n3;
        this.index0 = n4;
        this.index1 = n5;
        this.userPersistentData = object;
        this.appliedImpulse = f4;
        this.lateralFrictionInitialized = bl;
        this.appliedImpulseLateral1 = f5;
        this.appliedImpulseLateral2 = f6;
        this.lifeTime = n6;
        this.lateralFrictionDir1.set(vector3f6);
        this.lateralFrictionDir2.set(vector3f7);
    }

    public int getType() {
        return this.type;
    }

    public Spatial getNodeA() {
        if (this.nodeA.getUserObject() instanceof Spatial) {
            return (Spatial)this.nodeA.getUserObject();
        }
        return null;
    }

    public Spatial getNodeB() {
        if (this.nodeB.getUserObject() instanceof Spatial) {
            return (Spatial)this.nodeB.getUserObject();
        }
        return null;
    }

    public PhysicsCollisionObject getObjectA() {
        return this.nodeA;
    }

    public PhysicsCollisionObject getObjectB() {
        return this.nodeB;
    }

    public float getAppliedImpulse() {
        return this.appliedImpulse;
    }

    public float getAppliedImpulseLateral1() {
        return this.appliedImpulseLateral1;
    }

    public float getAppliedImpulseLateral2() {
        return this.appliedImpulseLateral2;
    }

    public float getCombinedFriction() {
        return this.combinedFriction;
    }

    public float getCombinedRestitution() {
        return this.combinedRestitution;
    }

    public float getDistance1() {
        return this.distance1;
    }

    public int getIndex0() {
        return this.index0;
    }

    public int getIndex1() {
        return this.index1;
    }

    public Vector3f getLateralFrictionDir1() {
        return this.lateralFrictionDir1;
    }

    public Vector3f getLateralFrictionDir2() {
        return this.lateralFrictionDir2;
    }

    public boolean isLateralFrictionInitialized() {
        return this.lateralFrictionInitialized;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public Vector3f getLocalPointA() {
        return this.localPointA;
    }

    public Vector3f getLocalPointB() {
        return this.localPointB;
    }

    public Vector3f getNormalWorldOnB() {
        return this.normalWorldOnB;
    }

    public int getPartId0() {
        return this.partId0;
    }

    public int getPartId1() {
        return this.partId1;
    }

    public Vector3f getPositionWorldOnA() {
        return this.positionWorldOnA;
    }

    public Vector3f getPositionWorldOnB() {
        return this.positionWorldOnB;
    }

    public Object getUserPersistentData() {
        return this.userPersistentData;
    }
}

