/*
 * Decompiled with CFR 0.152.
 */
package jme3test.water;

import com.jme3.input.InputManager;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.water.SimpleWaterProcessor;

public class WaterUI {
    private SimpleWaterProcessor processor;

    public WaterUI(InputManager inputManager, SimpleWaterProcessor proc) {
        this.processor = proc;
        System.out.println("----------------- SSAO UI Debugger --------------------");
        System.out.println("-- Water transparency : press Y to increase, H to decrease");
        System.out.println("-- Water depth : press U to increase, J to decrease");
        System.out.println("-------------------------------------------------------");
        inputManager.addMapping("transparencyUp", new Trigger[]{new KeyTrigger(21)});
        inputManager.addMapping("transparencyDown", new Trigger[]{new KeyTrigger(35)});
        inputManager.addMapping("depthUp", new Trigger[]{new KeyTrigger(22)});
        inputManager.addMapping("depthDown", new Trigger[]{new KeyTrigger(36)});
        AnalogListener anl = new AnalogListener(){

            public void onAnalog(String name, float value, float tpf) {
                if (name.equals("transparencyUp")) {
                    WaterUI.this.processor.setWaterTransparency(WaterUI.this.processor.getWaterTransparency() + 0.001f);
                    System.out.println("Water transparency : " + WaterUI.this.processor.getWaterTransparency());
                }
                if (name.equals("transparencyDown")) {
                    WaterUI.this.processor.setWaterTransparency(WaterUI.this.processor.getWaterTransparency() - 0.001f);
                    System.out.println("Water transparency : " + WaterUI.this.processor.getWaterTransparency());
                }
                if (name.equals("depthUp")) {
                    WaterUI.this.processor.setWaterDepth(WaterUI.this.processor.getWaterDepth() + 0.001f);
                    System.out.println("Water depth : " + WaterUI.this.processor.getWaterDepth());
                }
                if (name.equals("depthDown")) {
                    WaterUI.this.processor.setWaterDepth(WaterUI.this.processor.getWaterDepth() - 0.001f);
                    System.out.println("Water depth : " + WaterUI.this.processor.getWaterDepth());
                }
            }
        };
        inputManager.addListener((InputListener)anl, new String[]{"transparencyUp", "transparencyDown", "depthUp", "depthDown"});
    }
}

