/*
 * Decompiled with CFR 0.152.
 */
package jme3test.water;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioNode;
import com.jme3.audio.Filter;
import com.jme3.audio.LowPassFilter;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.post.filters.DepthOfFieldFilter;
import com.jme3.post.filters.LightScatteringFilter;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.SkyFactory;
import com.jme3.water.WaterFilter;
import java.awt.Image;
import java.util.ArrayList;
import jme3tools.converters.ImageToAwt;

public class TestPostWater
extends SimpleApplication {
    private Vector3f lightDir = new Vector3f(-4.923674f, -1.2705467f, 5.896916f);
    private WaterFilter water;
    TerrainQuad terrain;
    Material matRock;
    AudioNode waves;
    LowPassFilter underWaterAudioFilter = new LowPassFilter(0.5f, 0.1f);
    LowPassFilter underWaterReverbFilter = new LowPassFilter(0.5f, 0.1f);
    LowPassFilter aboveWaterAudioFilter = new LowPassFilter(1.0f, 1.0f);
    Geometry box;
    private float time = 0.0f;
    private float waterHeight = 0.0f;
    private float initialWaterHeight = 0.8f;
    private boolean uw = false;

    public static void main(String[] args) {
        TestPostWater app = new TestPostWater();
        app.start();
    }

    public void simpleInitApp() {
        this.setDisplayFps(false);
        this.setDisplayStatView(false);
        Node mainScene = new Node("Main Scene");
        this.rootNode.attachChild((Spatial)mainScene);
        this.createTerrain(mainScene);
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(this.lightDir);
        sun.setColor(ColorRGBA.White.clone().multLocal(1.7f));
        mainScene.addLight((Light)sun);
        DirectionalLight l = new DirectionalLight();
        l.setDirection(Vector3f.UNIT_Y.mult(-1.0f));
        l.setColor(ColorRGBA.White.clone().multLocal(0.3f));
        this.flyCam.setMoveSpeed(50.0f);
        this.cam.setLocation(new Vector3f(-327.21957f, 61.6459f, 126.884346f));
        this.cam.setRotation(new Quaternion(0.052168474f, 0.9443102f, -0.18395276f, 0.2678024f));
        this.cam.setRotation(new Quaternion().fromAngles(new float[]{0.18849556f, 2.042035f, 0.0f}));
        Spatial sky = SkyFactory.createSky((AssetManager)this.assetManager, (String)"Scenes/Beach/FullskiesSunset0068.dds", (boolean)false);
        sky.setLocalScale(350.0f);
        mainScene.attachChild(sky);
        this.cam.setFrustumFar(4000.0f);
        this.water = new WaterFilter(this.rootNode, this.lightDir);
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        fpp.addFilter((com.jme3.post.Filter)this.water);
        BloomFilter bloom = new BloomFilter();
        bloom.setExposurePower(55.0f);
        bloom.setBloomIntensity(1.0f);
        fpp.addFilter((com.jme3.post.Filter)bloom);
        LightScatteringFilter lsf = new LightScatteringFilter(this.lightDir.mult(-300.0f));
        lsf.setLightDensity(1.0f);
        fpp.addFilter((com.jme3.post.Filter)lsf);
        DepthOfFieldFilter dof = new DepthOfFieldFilter();
        dof.setFocusDistance(0.0f);
        dof.setFocusRange(100.0f);
        fpp.addFilter((com.jme3.post.Filter)dof);
        this.water.setWaveScale(0.003f);
        this.water.setMaxAmplitude(2.0f);
        this.water.setFoamExistence(new Vector3f(1.0f, 4.0f, 0.5f));
        this.water.setFoamTexture((Texture2D)this.assetManager.loadTexture("Common/MatDefs/Water/Textures/foam2.jpg"));
        this.water.setRefractionStrength(0.2f);
        this.water.setWaterHeight(this.initialWaterHeight);
        this.uw = this.cam.getLocation().y < this.waterHeight;
        this.waves = new AudioNode(this.audioRenderer, this.assetManager, "Sound/Environment/Ocean Waves.ogg", false);
        this.waves.setLooping(true);
        this.waves.setReverbEnabled(true);
        if (this.uw) {
            this.waves.setDryFilter((Filter)new LowPassFilter(0.5f, 0.1f));
        } else {
            this.waves.setDryFilter((Filter)this.aboveWaterAudioFilter);
        }
        this.audioRenderer.playSource(this.waves);
        this.viewPort.addProcessor((SceneProcessor)fpp);
        this.inputManager.addListener((InputListener)new ActionListener(){

            public void onAction(String name, boolean isPressed, float tpf) {
                if (isPressed) {
                    if (name.equals("foam1")) {
                        TestPostWater.this.water.setFoamTexture((Texture2D)TestPostWater.this.assetManager.loadTexture("Common/MatDefs/Water/Textures/foam.jpg"));
                    }
                    if (name.equals("foam2")) {
                        TestPostWater.this.water.setFoamTexture((Texture2D)TestPostWater.this.assetManager.loadTexture("Common/MatDefs/Water/Textures/foam2.jpg"));
                    }
                    if (name.equals("foam3")) {
                        TestPostWater.this.water.setFoamTexture((Texture2D)TestPostWater.this.assetManager.loadTexture("Common/MatDefs/Water/Textures/foam3.jpg"));
                    }
                }
            }
        }, new String[]{"foam1", "foam2", "foam3"});
        Trigger[] triggerArray = new Trigger[1];
        triggerArray[0] = new KeyTrigger(2);
        this.inputManager.addMapping("foam1", triggerArray);
        Trigger[] triggerArray2 = new Trigger[1];
        triggerArray2[0] = new KeyTrigger(3);
        this.inputManager.addMapping("foam2", triggerArray2);
        Trigger[] triggerArray3 = new Trigger[1];
        triggerArray3[0] = new KeyTrigger(4);
        this.inputManager.addMapping("foam3", triggerArray3);
    }

    private void createBox() {
        this.box = new Geometry("box", (Mesh)new Box(new Vector3f(0.0f, 0.0f, 0.0f), 50.0f, 50.0f, 50.0f));
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", new ColorRGBA(1.0f, 0.0f, 0.0f, 0.3f));
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.box.setMaterial(mat);
        this.box.setQueueBucket(RenderQueue.Bucket.Translucent);
        this.box.setLocalTranslation(-600.0f, 0.0f, 300.0f);
        this.rootNode.attachChild((Spatial)this.box);
    }

    private void createFire() {
        ParticleEmitter fire = new ParticleEmitter("Emitter", ParticleMesh.Type.Triangle, 30);
        Material mat_red = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat_red.setTexture("Texture", this.assetManager.loadTexture("Effects/Explosion/flame.png"));
        fire.setMaterial(mat_red);
        fire.setImagesX(2);
        fire.setImagesY(2);
        fire.setEndColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        fire.setStartColor(new ColorRGBA(1.0f, 1.0f, 0.0f, 0.5f));
        fire.getParticleInfluencer().setInitialVelocity(new Vector3f(0.0f, 2.0f, 0.0f));
        fire.setStartSize(10.0f);
        fire.setEndSize(1.0f);
        fire.setGravity(0.0f, 0.0f, 0.0f);
        fire.setLowLife(0.5f);
        fire.setHighLife(1.5f);
        fire.getParticleInfluencer().setVelocityVariation(0.3f);
        fire.setLocalTranslation(-350.0f, 40.0f, 430.0f);
        fire.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.rootNode.attachChild((Spatial)fire);
    }

    private void createTerrain(Node rootNode) {
        this.matRock = new Material(this.assetManager, "Common/MatDefs/Terrain/TerrainLighting.j3md");
        this.matRock.setBoolean("useTriPlanarMapping", false);
        this.matRock.setBoolean("WardIso", true);
        this.matRock.setTexture("AlphaMap", this.assetManager.loadTexture("Textures/Terrain/splat/alphamap.png"));
        Texture heightMapImage = this.assetManager.loadTexture("Textures/Terrain/splat/mountains512.png");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap", grass);
        this.matRock.setFloat("DiffuseMap_0_scale", 64.0f);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_1", dirt);
        this.matRock.setFloat("DiffuseMap_1_scale", 16.0f);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_2", rock);
        this.matRock.setFloat("DiffuseMap_2_scale", 128.0f);
        Texture normalMap0 = this.assetManager.loadTexture("Textures/Terrain/splat/grass_normal.jpg");
        normalMap0.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap1 = this.assetManager.loadTexture("Textures/Terrain/splat/dirt_normal.png");
        normalMap1.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap2 = this.assetManager.loadTexture("Textures/Terrain/splat/road_normal.png");
        normalMap2.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("NormalMap", normalMap0);
        this.matRock.setTexture("NormalMap_1", normalMap2);
        this.matRock.setTexture("NormalMap_2", normalMap2);
        ImageBasedHeightMap heightmap = null;
        try {
            heightmap = new ImageBasedHeightMap((Image)ImageToAwt.convert((com.jme3.texture.Image)heightMapImage.getImage(), (boolean)false, (boolean)true, (int)0), 0.25f);
            heightmap.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terrain = new TerrainQuad("terrain", 65, 513, heightmap.getHeightMap());
        ArrayList<Camera> cameras = new ArrayList<Camera>();
        cameras.add(this.getCamera());
        this.terrain.setMaterial(this.matRock);
        this.terrain.setLocalScale(new Vector3f(5.0f, 5.0f, 5.0f));
        this.terrain.setLocalTranslation(new Vector3f(0.0f, -30.0f, 0.0f));
        this.terrain.setLocked(false);
        this.terrain.setShadowMode(RenderQueue.ShadowMode.Receive);
        rootNode.attachChild((Spatial)this.terrain);
    }

    public void simpleUpdate(float tpf) {
        super.simpleUpdate(tpf);
        this.time += tpf;
        this.waterHeight = (float)Math.cos(this.time * 0.6f % ((float)Math.PI * 2)) * 1.5f;
        this.water.setWaterHeight(this.initialWaterHeight + this.waterHeight);
        if (this.water.isUnderWater() && !this.uw) {
            this.waves.setDryFilter((Filter)new LowPassFilter(0.5f, 0.1f));
            this.uw = true;
        }
        if (!this.water.isUnderWater() && this.uw) {
            this.uw = false;
            this.waves.setDryFilter((Filter)new LowPassFilter(1.0f, 1.0f));
        }
    }
}

