/*
 * Decompiled with CFR 0.152.
 */
package jme3test.texture;

import com.jme3.app.SimpleApplication;
import com.jme3.bounding.BoundingBox;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class TestTexture3D
extends SimpleApplication {
    public static void main(String[] args) {
        TestTexture3D app = new TestTexture3D();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(10.0f);
        Sphere sphere = new Sphere(32, 32, 1.0f);
        sphere.updateBound();
        BoundingBox bb = (BoundingBox)sphere.getBound();
        Vector3f min = bb.getMin(null);
        float[] ext = new float[]{bb.getXExtent() * 2.0f, bb.getYExtent() * 2.0f, bb.getZExtent() * 2.0f};
        sphere.clearBuffer(VertexBuffer.Type.TexCoord);
        VertexBuffer vb = sphere.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fb = (FloatBuffer)vb.getData();
        float[] uvCoordinates = BufferUtils.getFloatArray((FloatBuffer)fb);
        for (int i = 0; i < uvCoordinates.length; i += 3) {
            uvCoordinates[i] = (uvCoordinates[i] - min.x) / ext[0];
            uvCoordinates[i + 1] = (uvCoordinates[i + 1] - min.y) / ext[1];
            uvCoordinates[i + 2] = (uvCoordinates[i + 2] - min.z) / ext[2];
        }
        VertexBuffer uvCoordsBuffer = new VertexBuffer(VertexBuffer.Type.TexCoord);
        uvCoordsBuffer.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((float[])uvCoordinates));
        sphere.setBuffer(uvCoordsBuffer);
        Geometry g = new Geometry("sphere", (Mesh)sphere);
        Material material = new Material(this.assetManager, "jme3test/texture/tex3D.j3md");
        try {
            Texture texture = this.getTexture();
            material.setTexture("Texture", texture);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        g.setMaterial(material);
        this.rootNode.attachChild((Spatial)g);
        PointLight light = new PointLight();
        light.setColor(ColorRGBA.White);
        light.setPosition(new Vector3f(5.0f, 5.0f, 5.0f));
        light.setRadius(20.0f);
        this.rootNode.addLight((Light)light);
        light = new PointLight();
        light.setColor(ColorRGBA.White);
        light.setPosition(new Vector3f(-5.0f, -5.0f, -5.0f));
        light.setRadius(20.0f);
        this.rootNode.addLight((Light)light);
    }

    private Texture getTexture() throws IOException {
        ArrayList<ByteBuffer> data = new ArrayList<ByteBuffer>(1);
        ByteBuffer bb = BufferUtils.createByteBuffer((int)3000);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 100; ++j) {
                bb.put((byte)(255.0f * (float)i / 10.0f));
                bb.put((byte)(255.0f * (float)i / 10.0f));
                bb.put((byte)-1);
            }
        }
        bb.rewind();
        data.add(bb);
        return new Texture3D(new Image(Image.Format.RGB8, 10, 10, 10, data));
    }
}

