/*
 * Decompiled with CFR 0.152.
 */
package jme3test.stress;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.GLObjectManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestLeakingGL
extends SimpleApplication {
    private Material solidColor;
    private Sphere original;

    public static void main(String[] args) {
        TestLeakingGL app = new TestLeakingGL();
        app.start();
    }

    public void simpleInitApp() {
        this.original = new Sphere(4, 4, 1.0f);
        this.original.setStatic();
        this.original.setInterleaved();
        this.rootNode.setCullHint(Spatial.CullHint.Never);
        this.solidColor = this.assetManager.loadMaterial("Common/Materials/RedColor.j3m");
        this.cam.setLocation(new Vector3f(0.0f, 5.0f, 0.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        Logger.getLogger(Node.class.getName()).setLevel(Level.WARNING);
        Logger.getLogger(GLObjectManager.class.getName()).setLevel(Level.WARNING);
    }

    public void simpleUpdate(float tpf) {
        this.rootNode.detachAllChildren();
        for (int y = -15; y < 15; ++y) {
            for (int x = -15; x < 15; ++x) {
                Mesh sphMesh = this.original.deepClone();
                Geometry sphere = new Geometry("sphere", sphMesh);
                sphere.setMaterial(this.solidColor);
                sphere.setLocalTranslation((float)x * 1.5f, 0.0f, (float)y * 1.5f);
                this.rootNode.attachChild((Spatial)sphere);
            }
        }
    }
}

