/*
 * Decompiled with CFR 0.152.
 */
package jme3test.scene;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.SkyFactory;
import java.io.File;

public class TestSceneLoading
extends SimpleApplication {
    private Sphere sphereMesh = new Sphere(32, 32, 10.0f, false, true);
    private Geometry sphere = new Geometry("Sky", (Mesh)this.sphereMesh);
    private static boolean useHttp = false;

    public static void main(String[] args) {
        TestSceneLoading app = new TestSceneLoading();
        app.start();
    }

    public void simpleUpdate(float tpf) {
        this.sphere.setLocalTranslation(this.cam.getLocation());
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(10.0f);
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/BrightSky.dds", (boolean)false));
        File file = new File("wildhouse.zip");
        if (!file.exists()) {
            useHttp = true;
        }
        if (useHttp) {
            this.assetManager.registerLocator("http://jmonkeyengine.googlecode.com/files/wildhouse.zip", HttpZipLocator.class.getName());
        } else {
            this.assetManager.registerLocator("wildhouse.zip", ZipLocator.class.getName());
        }
        Spatial scene = this.assetManager.loadModel("main.scene");
        AmbientLight al = new AmbientLight();
        scene.addLight((Light)al);
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(0.69077975f, -0.6277887f, -0.35875428f).normalizeLocal());
        sun.setColor(ColorRGBA.White.clone().multLocal(2.0f));
        scene.addLight((Light)sun);
        this.rootNode.attachChild(scene);
    }
}

