/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.CartoonEdgeFilter;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;

public class TestTransparentCartoonEdge
extends SimpleApplication {
    public static void main(String[] args) {
        TestTransparentCartoonEdge app = new TestTransparentCartoonEdge();
        app.start();
    }

    public void simpleInitApp() {
        this.renderManager.setAlphaToCoverage(true);
        this.cam.setLocation(new Vector3f(0.14914267f, 0.58147097f, 4.7686534f));
        this.cam.setRotation(new Quaternion(-0.0044764364f, 0.9767943f, 0.21314798f, 0.020512417f));
        this.viewPort.setBackgroundColor(ColorRGBA.DarkGray);
        Quad q = new Quad(20.0f, 20.0f);
        q.scaleTextureCoordinates(Vector2f.UNIT_XY.mult(5.0f));
        Geometry geom = new Geometry("floor", (Mesh)q);
        Material mat = this.assetManager.loadMaterial("Textures/Terrain/Pond/Pond.j3m");
        geom.setMaterial(mat);
        geom.rotate(-1.5707964f, 0.0f, 0.0f);
        geom.center();
        geom.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.rootNode.attachChild((Spatial)geom);
        Spatial teaGeom = this.assetManager.loadModel("Models/Tree/Tree2.mesh.xml");
        teaGeom.setQueueBucket(RenderQueue.Bucket.Transparent);
        teaGeom.setShadowMode(RenderQueue.ShadowMode.Cast);
        this.makeToonish(teaGeom);
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(2.0f));
        this.rootNode.addLight((Light)al);
        DirectionalLight dl1 = new DirectionalLight();
        dl1.setDirection(new Vector3f(1.0f, -1.0f, 1.0f).normalizeLocal());
        dl1.setColor(new ColorRGBA(0.965f, 0.949f, 0.772f, 1.0f).mult(0.7f));
        this.rootNode.addLight((Light)dl1);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(0.965f, 0.949f, 0.772f, 1.0f).mult(0.7f));
        this.rootNode.addLight((Light)dl);
        this.rootNode.attachChild(teaGeom);
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        CartoonEdgeFilter toon = new CartoonEdgeFilter();
        toon.setEdgeWidth(0.5f);
        toon.setEdgeIntensity(1.0f);
        toon.setNormalThreshold(0.8f);
        fpp.addFilter((Filter)toon);
        this.viewPort.addProcessor((SceneProcessor)fpp);
    }

    public void makeToonish(Spatial spatial) {
        Geometry g;
        Material m;
        if (spatial instanceof Node) {
            Node n = (Node)spatial;
            for (Spatial child : n.getChildren()) {
                this.makeToonish(child);
            }
        } else if (spatial instanceof Geometry && (m = (g = (Geometry)spatial).getMaterial()).getMaterialDef().getName().equals("Phong Lighting")) {
            Texture t = this.assetManager.loadTexture("Textures/ColorRamp/toon.png");
            m.setTexture("ColorRamp", t);
            m.setBoolean("UseMaterialColors", true);
            m.setColor("Specular", ColorRGBA.Black);
            m.setColor("Diffuse", ColorRGBA.White);
            m.setBoolean("VertexLighting", true);
        }
    }
}

