/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;

public class TestRenderToTexture
extends SimpleApplication
implements ActionListener {
    private static final String TOGGLE_UPDATE = "Toggle Update";
    private Geometry offBox;
    private float angle = 0.0f;
    private ViewPort offView;

    public static void main(String[] args) {
        TestRenderToTexture app = new TestRenderToTexture();
        app.start();
    }

    public Texture setupOffscreenView() {
        Camera offCamera = new Camera(512, 512);
        this.offView = this.renderManager.createPreView("Offscreen View", offCamera);
        this.offView.setClearFlags(true, true, true);
        this.offView.setBackgroundColor(ColorRGBA.DarkGray);
        FrameBuffer offBuffer = new FrameBuffer(512, 512, 1);
        offCamera.setFrustumPerspective(45.0f, 1.0f, 1.0f, 1000.0f);
        offCamera.setLocation(new Vector3f(0.0f, 0.0f, -5.0f));
        offCamera.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        Texture2D offTex = new Texture2D(512, 512, Image.Format.RGBA8);
        offTex.setMinFilter(Texture.MinFilter.Trilinear);
        offTex.setMagFilter(Texture.MagFilter.Bilinear);
        offBuffer.setDepthBuffer(Image.Format.Depth);
        offBuffer.setColorTexture(offTex);
        this.offView.setOutputFrameBuffer(offBuffer);
        Box boxMesh = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        Material material = this.assetManager.loadMaterial("Interface/Logo/Logo.j3m");
        this.offBox = new Geometry("box", (Mesh)boxMesh);
        this.offBox.setMaterial(material);
        this.offView.attachScene((Spatial)this.offBox);
        return offTex;
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(3.0f, 3.0f, 3.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        Geometry quad = new Geometry("box", (Mesh)new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f));
        Texture offTex = this.setupOffscreenView();
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", offTex);
        quad.setMaterial(mat);
        this.rootNode.attachChild((Spatial)quad);
        this.inputManager.addMapping(TOGGLE_UPDATE, new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)this, new String[]{TOGGLE_UPDATE});
    }

    public void simpleUpdate(float tpf) {
        Quaternion q = new Quaternion();
        if (this.offView.isEnabled()) {
            this.angle += tpf;
            this.angle %= (float)Math.PI * 2;
            q.fromAngles(this.angle, 0.0f, this.angle);
            this.offBox.setLocalRotation(q);
            this.offBox.updateLogicalState(tpf);
            this.offBox.updateGeometricState();
        }
    }

    public void onAction(String name, boolean isPressed, float tpf) {
        if (name.equals(TOGGLE_UPDATE) && isPressed) {
            this.offView.setEnabled(!this.offView.isEnabled());
        }
    }
}

