/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import com.jme3.util.Screenshots;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TestRenderToMemory
extends SimpleApplication
implements SceneProcessor {
    private Geometry offBox;
    private float angle = 0.0f;
    private FrameBuffer offBuffer;
    private ViewPort offView;
    private Texture2D offTex;
    private Camera offCamera;
    private ImageDisplay display;
    private static final int width = 800;
    private static final int height = 600;
    private final ByteBuffer cpuBuf = BufferUtils.createByteBuffer((int)1920000);
    private final byte[] cpuArray = new byte[1920000];
    private final BufferedImage image = new BufferedImage(800, 600, 6);

    public static void main(String[] args) {
        TestRenderToMemory app = new TestRenderToMemory();
        app.setPauseOnLostFocus(false);
        AppSettings settings = new AppSettings(true);
        settings.setResolution(1, 1);
        app.setSettings(settings);
        app.start(JmeContext.Type.OffscreenSurface);
    }

    public void createDisplayFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("Render Display");
                TestRenderToMemory.this.display = new ImageDisplay();
                TestRenderToMemory.this.display.setPreferredSize(new Dimension(800, 600));
                frame.getContentPane().add(TestRenderToMemory.this.display);
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent e) {
                        TestRenderToMemory.this.stop();
                    }
                });
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setResizable(false);
                frame.setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImageContents() {
        this.cpuBuf.clear();
        this.renderer.readFrameBuffer(this.offBuffer, this.cpuBuf);
        BufferedImage bufferedImage = this.image;
        synchronized (bufferedImage) {
            Screenshots.convertScreenShot((ByteBuffer)this.cpuBuf, (BufferedImage)this.image);
        }
        if (this.display != null) {
            this.display.repaint();
        }
    }

    public void setupOffscreenView() {
        this.offCamera = new Camera(800, 600);
        this.offView = this.renderManager.createPreView("Offscreen View", this.offCamera);
        this.offView.setBackgroundColor(ColorRGBA.DarkGray);
        this.offView.setClearFlags(true, true, true);
        this.offView.addProcessor((SceneProcessor)this);
        this.offBuffer = new FrameBuffer(800, 600, 1);
        this.offCamera.setFrustumPerspective(45.0f, 1.0f, 1.0f, 1000.0f);
        this.offCamera.setLocation(new Vector3f(0.0f, 0.0f, -5.0f));
        this.offCamera.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        this.offBuffer.setDepthBuffer(Image.Format.Depth);
        this.offBuffer.setColorBuffer(Image.Format.RGBA8);
        this.offView.setOutputFrameBuffer(this.offBuffer);
        Box boxMesh = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        Material material = this.assetManager.loadMaterial("Interface/Logo/Logo.j3m");
        this.offBox = new Geometry("box", (Mesh)boxMesh);
        this.offBox.setMaterial(material);
        this.offView.attachScene((Spatial)this.offBox);
    }

    public void simpleInitApp() {
        this.setupOffscreenView();
        this.createDisplayFrame();
    }

    public void simpleUpdate(float tpf) {
        Quaternion q = new Quaternion();
        this.angle += tpf;
        this.angle %= (float)Math.PI * 2;
        q.fromAngles(this.angle, 0.0f, this.angle);
        this.offBox.setLocalRotation(q);
        this.offBox.updateLogicalState(tpf);
        this.offBox.updateGeometricState();
    }

    public void initialize(RenderManager rm, ViewPort vp) {
    }

    public void reshape(ViewPort vp, int w, int h) {
    }

    public boolean isInitialized() {
        return true;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        this.updateImageContents();
    }

    public void cleanup() {
    }

    private class ImageDisplay
    extends JPanel {
        private long t;
        private long total;
        private int frames;
        private int fps;

        private ImageDisplay() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics gfx) {
            super.paintComponent(gfx);
            Graphics2D g2d = (Graphics2D)gfx;
            if (this.t == 0L) {
                this.t = TestRenderToMemory.this.timer.getTime();
            }
            BufferedImage bufferedImage = TestRenderToMemory.this.image;
            synchronized (bufferedImage) {
                g2d.drawImage(TestRenderToMemory.this.image, null, 0, 0);
            }
            long t2 = TestRenderToMemory.this.timer.getTime();
            long dt = t2 - this.t;
            this.total += dt;
            ++this.frames;
            this.t = t2;
            if (this.total > 1000L) {
                this.fps = this.frames;
                this.total = 0L;
                this.frames = 0;
            }
            g2d.setColor(Color.white);
            g2d.drawString("FPS: " + this.fps, 0, this.getHeight() - 100);
        }
    }
}

