/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.ColorOverlayFilter;
import com.jme3.post.filters.FadeFilter;
import com.jme3.post.filters.RadialBlurFilter;
import com.jme3.renderer.Caps;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import com.jme3.util.TangentBinormalGenerator;

public class TestPostFilters
extends SimpleApplication
implements ActionListener {
    private FilterPostProcessor fpp;
    private Vector3f lightDir = new Vector3f(-1.0f, -1.0f, 0.5f).normalizeLocal();
    FadeFilter fade;

    public static void main(String[] args) {
        TestPostFilters app = new TestPostFilters();
        app.start();
    }

    public void setupFilters() {
        if (this.renderer.getCaps().contains(Caps.GLSL100)) {
            this.fpp = new FilterPostProcessor(this.assetManager);
            this.fpp.addFilter((Filter)new ColorOverlayFilter(ColorRGBA.LightGray));
            this.fpp.addFilter((Filter)new RadialBlurFilter());
            this.viewPort.addProcessor((SceneProcessor)this.fpp);
        }
    }

    public void setupSkyBox() {
        Texture envMap = this.renderer.getCaps().contains(Caps.FloatTexture) ? this.assetManager.loadTexture("Textures/Sky/St Peters/StPeters.hdr") : this.assetManager.loadTexture("Textures/Sky/St Peters/StPeters.jpg");
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (Texture)envMap, (Vector3f)new Vector3f(-1.0f, -1.0f, -1.0f), (boolean)true));
    }

    public void setupLighting() {
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(this.lightDir);
        dl.setColor(new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        this.rootNode.addLight((Light)dl);
        dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1.0f, 0.0f, -1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(0.4f, 0.4f, 0.4f, 1.0f));
        this.rootNode.addLight((Light)dl);
    }

    public void setupFloor() {
        Material mat = this.assetManager.loadMaterial("Textures/Terrain/BrickWall/BrickWall.j3m");
        mat.getTextureParam("DiffuseMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        mat.getTextureParam("NormalMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        mat.getTextureParam("ParallaxMap").getTextureValue().setWrap(Texture.WrapMode.Repeat);
        Box floor = new Box(Vector3f.ZERO, 50.0f, 1.0f, 50.0f);
        TangentBinormalGenerator.generate((Mesh)floor);
        floor.scaleTextureCoordinates(new Vector2f(5.0f, 5.0f));
        Geometry floorGeom = new Geometry("Floor", (Mesh)floor);
        floorGeom.setMaterial(mat);
        floorGeom.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.rootNode.attachChild((Spatial)floorGeom);
    }

    public void setupSignpost() {
        Spatial signpost = this.assetManager.loadModel("Models/Sign Post/Sign Post.mesh.xml");
        Material mat = this.assetManager.loadMaterial("Models/Sign Post/Sign Post.j3m");
        signpost.setMaterial(mat);
        signpost.rotate(0.0f, 1.5707964f, 0.0f);
        signpost.setLocalTranslation(12.0f, 3.5f, 30.0f);
        signpost.setLocalScale(4.0f);
        signpost.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild(signpost);
    }

    public void simpleInitApp() {
        this.cam.setLocation(new Vector3f(-32.295086f, 54.80136f, 79.59805f));
        this.cam.setRotation(new Quaternion(0.074364014f, 0.92519957f, -0.24794696f, 0.27748522f));
        this.cam.update();
        this.cam.setFrustumFar(300.0f);
        this.flyCam.setMoveSpeed(30.0f);
        this.rootNode.setCullHint(Spatial.CullHint.Never);
        this.setupLighting();
        this.setupSkyBox();
        this.setupFloor();
        this.setupSignpost();
        this.setupFilters();
        this.initInput();
    }

    protected void initInput() {
        this.flyCam.setMoveSpeed(3.0f);
        this.inputManager.addMapping("fadein", new Trigger[]{new KeyTrigger(23)});
        this.inputManager.addListener((InputListener)this, new String[]{"fadein"});
        this.inputManager.addMapping("fadeout", new Trigger[]{new KeyTrigger(24)});
        this.inputManager.addListener((InputListener)this, new String[]{"fadeout"});
    }

    public void onAction(String name, boolean value, float tpf) {
        if (name.equals("fadein") && value) {
            this.fade.fadeIn();
            System.out.println("fade in");
        }
        if (name.equals("fadeout") && value) {
            this.fade.fadeOut();
            System.out.println("fade out");
        }
    }
}

