/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.HttpZipLocator;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.post.filters.ColorOverlayFilter;
import com.jme3.post.ssao.SSAOFilter;
import com.jme3.scene.Spatial;
import com.jme3.util.SkyFactory;
import com.jme3.water.WaterFilter;
import java.io.File;
import jme3test.post.SSAOUI;

public class TestMultiplesFilters
extends SimpleApplication {
    private static boolean useHttp = false;
    SSAOFilter ssaoFilter;
    FilterPostProcessor fpp;
    boolean en = true;

    public static void main(String[] args) {
        File file = new File("wildhouse.zip");
        if (!file.exists()) {
            useHttp = true;
        }
        TestMultiplesFilters app = new TestMultiplesFilters();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(10.0f);
        this.cam.setLocation(new Vector3f(6.0344796f, 1.5054002f, 55.572033f));
        this.cam.setRotation(new Quaternion(0.0016069f, 0.9810479f, -0.008143323f, 0.19358753f));
        this.rootNode.attachChild(SkyFactory.createSky((AssetManager)this.assetManager, (String)"Textures/Sky/Bright/BrightSky.dds", (boolean)false));
        if (useHttp) {
            this.assetManager.registerLocator("http://jmonkeyengine.googlecode.com/files/wildhouse.zip", HttpZipLocator.class.getName());
        } else {
            this.assetManager.registerLocator("wildhouse.zip", ZipLocator.class.getName());
        }
        Spatial scene = this.assetManager.loadModel("main.scene");
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(-0.4790551f, -0.39247334f, -0.7851566f));
        sun.setColor(ColorRGBA.White.clone().multLocal(2.0f));
        scene.addLight((Light)sun);
        this.fpp = new FilterPostProcessor(this.assetManager);
        this.ssaoFilter = new SSAOFilter(0.92f, 2.2f, 0.46f, 0.2f);
        final WaterFilter water = new WaterFilter(this.rootNode, new Vector3f(-0.4790551f, -0.39247334f, -0.7851566f));
        water.setWaterHeight(-20.0f);
        SSAOUI ui = new SSAOUI(this.inputManager, this.ssaoFilter);
        final BloomFilter bloom = new BloomFilter();
        final ColorOverlayFilter overlay = new ColorOverlayFilter(ColorRGBA.LightGray);
        this.fpp.addFilter((Filter)this.ssaoFilter);
        this.fpp.addFilter((Filter)water);
        this.fpp.addFilter((Filter)bloom);
        this.fpp.addFilter((Filter)overlay);
        this.viewPort.addProcessor((SceneProcessor)this.fpp);
        this.rootNode.attachChild(scene);
        this.inputManager.addListener((InputListener)new ActionListener(){

            public void onAction(String name, boolean isPressed, float tpf) {
                if ("toggleSSAO".equals(name) && isPressed) {
                    if (TestMultiplesFilters.this.ssaoFilter.isEnabled()) {
                        TestMultiplesFilters.this.ssaoFilter.setEnabled(false);
                    } else {
                        TestMultiplesFilters.this.ssaoFilter.setEnabled(true);
                    }
                }
                if ("toggleWater".equals(name) && isPressed) {
                    if (water.isEnabled()) {
                        water.setEnabled(false);
                    } else {
                        water.setEnabled(true);
                    }
                }
                if ("toggleBloom".equals(name) && isPressed) {
                    if (bloom.isEnabled()) {
                        bloom.setEnabled(false);
                    } else {
                        bloom.setEnabled(true);
                    }
                }
                if ("toggleOverlay".equals(name) && isPressed) {
                    if (overlay.isEnabled()) {
                        overlay.setEnabled(false);
                    } else {
                        overlay.setEnabled(true);
                    }
                }
            }
        }, new String[]{"toggleSSAO", "toggleBloom", "toggleWater", "toggleOverlay"});
        this.inputManager.addMapping("toggleSSAO", new Trigger[]{new KeyTrigger(2)});
        this.inputManager.addMapping("toggleWater", new Trigger[]{new KeyTrigger(3)});
        this.inputManager.addMapping("toggleBloom", new Trigger[]{new KeyTrigger(4)});
        this.inputManager.addMapping("toggleOverlay", new Trigger[]{new KeyTrigger(5)});
    }
}

