/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.DepthOfFieldFilter;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import java.awt.Image;
import java.util.ArrayList;
import jme3tools.converters.ImageToAwt;

public class TestDepthOfField
extends SimpleApplication {
    private FilterPostProcessor fpp;
    private Vector3f lightDir = new Vector3f(-4.923674f, -1.2705467f, 5.896916f);
    TerrainQuad terrain;
    Material matRock;
    DepthOfFieldFilter dofFilter;

    public static void main(String[] args) {
        TestDepthOfField app = new TestDepthOfField();
        app.start();
    }

    public void simpleInitApp() {
        Node mainScene = new Node("Main Scene");
        this.rootNode.attachChild((Spatial)mainScene);
        this.createTerrain(mainScene);
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(this.lightDir);
        sun.setColor(ColorRGBA.White.clone().multLocal(1.7f));
        mainScene.addLight((Light)sun);
        DirectionalLight l = new DirectionalLight();
        l.setDirection(Vector3f.UNIT_Y.mult(-1.0f));
        l.setColor(ColorRGBA.White.clone().multLocal(0.3f));
        mainScene.addLight((Light)l);
        this.flyCam.setMoveSpeed(50.0f);
        this.cam.setFrustumFar(3000.0f);
        this.cam.setLocation(new Vector3f(-700.0f, 100.0f, 300.0f));
        this.cam.setRotation(new Quaternion().fromAngles(new float[]{0.18849556f, 2.042035f, 0.0f}));
        Spatial sky = SkyFactory.createSky((AssetManager)this.assetManager, (String)"Scenes/Beach/FullskiesSunset0068.dds", (boolean)false);
        sky.setLocalScale(350.0f);
        mainScene.attachChild(sky);
        this.fpp = new FilterPostProcessor(this.assetManager);
        this.dofFilter = new DepthOfFieldFilter();
        this.dofFilter.setFocusDistance(0.0f);
        this.dofFilter.setFocusRange(50.0f);
        this.dofFilter.setBlurScale(1.4f);
        this.fpp.addFilter((Filter)this.dofFilter);
        this.viewPort.addProcessor((SceneProcessor)this.fpp);
        this.inputManager.addListener((InputListener)new ActionListener(){

            public void onAction(String name, boolean isPressed, float tpf) {
                if (isPressed && name.equals("toggle")) {
                    TestDepthOfField.this.dofFilter.setEnabled(!TestDepthOfField.this.dofFilter.isEnabled());
                }
            }
        }, new String[]{"toggle"});
        this.inputManager.addListener((InputListener)new AnalogListener(){

            public void onAnalog(String name, float value, float tpf) {
                if (name.equals("blurScaleUp")) {
                    TestDepthOfField.this.dofFilter.setBlurScale(TestDepthOfField.this.dofFilter.getBlurScale() + 0.01f);
                    System.out.println("blurScale : " + TestDepthOfField.this.dofFilter.getBlurScale());
                }
                if (name.equals("blurScaleDown")) {
                    TestDepthOfField.this.dofFilter.setBlurScale(TestDepthOfField.this.dofFilter.getBlurScale() - 0.01f);
                    System.out.println("blurScale : " + TestDepthOfField.this.dofFilter.getBlurScale());
                }
                if (name.equals("focusRangeUp")) {
                    TestDepthOfField.this.dofFilter.setFocusRange(TestDepthOfField.this.dofFilter.getFocusRange() + 1.0f);
                    System.out.println("focusRange : " + TestDepthOfField.this.dofFilter.getFocusRange());
                }
                if (name.equals("focusRangeDown")) {
                    TestDepthOfField.this.dofFilter.setFocusRange(TestDepthOfField.this.dofFilter.getFocusRange() - 1.0f);
                    System.out.println("focusRange : " + TestDepthOfField.this.dofFilter.getFocusRange());
                }
                if (name.equals("focusDistanceUp")) {
                    TestDepthOfField.this.dofFilter.setFocusDistance(TestDepthOfField.this.dofFilter.getFocusDistance() + 1.0f);
                    System.out.println("focusDistance : " + TestDepthOfField.this.dofFilter.getFocusDistance());
                }
                if (name.equals("focusDistanceDown")) {
                    TestDepthOfField.this.dofFilter.setFocusDistance(TestDepthOfField.this.dofFilter.getFocusDistance() - 1.0f);
                    System.out.println("focusDistance : " + TestDepthOfField.this.dofFilter.getFocusDistance());
                }
            }
        }, new String[]{"blurScaleUp", "blurScaleDown", "focusRangeUp", "focusRangeDown", "focusDistanceUp", "focusDistanceDown"});
        Trigger[] triggerArray = new Trigger[1];
        triggerArray[0] = new KeyTrigger(57);
        this.inputManager.addMapping("toggle", triggerArray);
        Trigger[] triggerArray2 = new Trigger[1];
        triggerArray2[0] = new KeyTrigger(22);
        this.inputManager.addMapping("blurScaleUp", triggerArray2);
        Trigger[] triggerArray3 = new Trigger[1];
        triggerArray3[0] = new KeyTrigger(36);
        this.inputManager.addMapping("blurScaleDown", triggerArray3);
        Trigger[] triggerArray4 = new Trigger[1];
        triggerArray4[0] = new KeyTrigger(23);
        this.inputManager.addMapping("focusRangeUp", triggerArray4);
        Trigger[] triggerArray5 = new Trigger[1];
        triggerArray5[0] = new KeyTrigger(37);
        this.inputManager.addMapping("focusRangeDown", triggerArray5);
        Trigger[] triggerArray6 = new Trigger[1];
        triggerArray6[0] = new KeyTrigger(24);
        this.inputManager.addMapping("focusDistanceUp", triggerArray6);
        Trigger[] triggerArray7 = new Trigger[1];
        triggerArray7[0] = new KeyTrigger(38);
        this.inputManager.addMapping("focusDistanceDown", triggerArray7);
    }

    private void createTerrain(Node rootNode) {
        this.matRock = new Material(this.assetManager, "Common/MatDefs/Terrain/TerrainLighting.j3md");
        this.matRock.setBoolean("useTriPlanarMapping", false);
        this.matRock.setBoolean("WardIso", true);
        this.matRock.setTexture("AlphaMap", this.assetManager.loadTexture("Textures/Terrain/splat/alphamap.png"));
        Texture heightMapImage = this.assetManager.loadTexture("Textures/Terrain/splat/mountains512.png");
        Texture grass = this.assetManager.loadTexture("Textures/Terrain/splat/grass.jpg");
        grass.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap", grass);
        this.matRock.setFloat("DiffuseMap_0_scale", 64.0f);
        Texture dirt = this.assetManager.loadTexture("Textures/Terrain/splat/dirt.jpg");
        dirt.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_1", dirt);
        this.matRock.setFloat("DiffuseMap_1_scale", 16.0f);
        Texture rock = this.assetManager.loadTexture("Textures/Terrain/splat/road.jpg");
        rock.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("DiffuseMap_2", rock);
        this.matRock.setFloat("DiffuseMap_2_scale", 128.0f);
        Texture normalMap0 = this.assetManager.loadTexture("Textures/Terrain/splat/grass_normal.jpg");
        normalMap0.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap1 = this.assetManager.loadTexture("Textures/Terrain/splat/dirt_normal.png");
        normalMap1.setWrap(Texture.WrapMode.Repeat);
        Texture normalMap2 = this.assetManager.loadTexture("Textures/Terrain/splat/road_normal.png");
        normalMap2.setWrap(Texture.WrapMode.Repeat);
        this.matRock.setTexture("NormalMap", normalMap0);
        this.matRock.setTexture("NormalMap_1", normalMap2);
        this.matRock.setTexture("NormalMap_2", normalMap2);
        ImageBasedHeightMap heightmap = null;
        try {
            heightmap = new ImageBasedHeightMap((Image)ImageToAwt.convert((com.jme3.texture.Image)heightMapImage.getImage(), (boolean)false, (boolean)true, (int)0), 0.25f);
            heightmap.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terrain = new TerrainQuad("terrain", 65, 513, heightmap.getHeightMap());
        ArrayList<Camera> cameras = new ArrayList<Camera>();
        cameras.add(this.getCamera());
        this.terrain.setMaterial(this.matRock);
        this.terrain.setLocalScale(new Vector3f(5.0f, 5.0f, 5.0f));
        this.terrain.setLocalTranslation(new Vector3f(0.0f, -30.0f, 0.0f));
        this.terrain.setLocked(false);
        this.terrain.setShadowMode(RenderQueue.ShadowMode.Receive);
        rootNode.attachChild((Spatial)this.terrain);
    }

    public void simpleUpdate(float tpf) {
        Vector3f origin = this.cam.getWorldCoordinates(new Vector2f((float)(this.settings.getWidth() / 2), (float)(this.settings.getHeight() / 2)), 0.0f);
        Vector3f direction = this.cam.getWorldCoordinates(new Vector2f((float)(this.settings.getWidth() / 2), (float)(this.settings.getHeight() / 2)), 0.3f);
        direction.subtractLocal(origin).normalizeLocal();
        Ray ray = new Ray(origin, direction);
        CollisionResults results = new CollisionResults();
        int numCollisions = this.terrain.collideWith((Collidable)ray, results);
        if (numCollisions > 0) {
            CollisionResult hit = results.getClosestCollision();
            this.fpsText.setText("" + hit.getDistance());
            this.dofFilter.setFocusDistance(hit.getDistance() / 10.0f);
        }
    }
}

