/*
 * Decompiled with CFR 0.152.
 */
package jme3test.post;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.CartoonEdgeFilter;
import com.jme3.renderer.Caps;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;

public class TestCartoonEdge
extends SimpleApplication {
    private FilterPostProcessor fpp;

    public static void main(String[] args) {
        TestCartoonEdge app = new TestCartoonEdge();
        app.start();
    }

    public void setupFilters() {
        if (this.renderer.getCaps().contains(Caps.GLSL100)) {
            this.fpp = new FilterPostProcessor(this.assetManager);
            CartoonEdgeFilter toon = new CartoonEdgeFilter();
            toon.setEdgeColor(ColorRGBA.Yellow);
            this.fpp.addFilter((Filter)toon);
            this.viewPort.addProcessor((SceneProcessor)this.fpp);
        }
    }

    public void makeToonish(Spatial spatial) {
        Geometry g;
        Material m;
        if (spatial instanceof Node) {
            Node n = (Node)spatial;
            for (Spatial child : n.getChildren()) {
                this.makeToonish(child);
            }
        } else if (spatial instanceof Geometry && (m = (g = (Geometry)spatial).getMaterial()).getMaterialDef().getName().equals("Phong Lighting")) {
            Texture t = this.assetManager.loadTexture("Textures/ColorRamp/toon.png");
            m.setTexture("ColorRamp", t);
            m.setBoolean("UseMaterialColors", true);
            m.setColor("Specular", ColorRGBA.Black);
            m.setColor("Diffuse", ColorRGBA.White);
            m.setBoolean("VertexLighting", true);
        }
    }

    public void setupLighting() {
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-1.0f, -1.0f, 1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(2.0f, 2.0f, 2.0f, 1.0f));
        this.rootNode.addLight((Light)dl);
    }

    public void setupModel() {
        Spatial model = this.assetManager.loadModel("Models/MonkeyHead/MonkeyHead.mesh.xml");
        this.makeToonish(model);
        model.rotate(0.0f, (float)Math.PI, 0.0f);
        this.rootNode.attachChild(model);
    }

    public void simpleInitApp() {
        this.viewPort.setBackgroundColor(ColorRGBA.Gray);
        this.cam.setLocation(new Vector3f(-5.6310086f, 5.0892987f, -13.000479f));
        this.cam.setRotation(new Quaternion(0.1779095f, 0.20036356f, -0.03702727f, 0.96272093f));
        this.cam.update();
        this.cam.setFrustumFar(300.0f);
        this.flyCam.setMoveSpeed(30.0f);
        this.rootNode.setCullHint(Spatial.CullHint.Never);
        this.setupLighting();
        this.setupModel();
        this.setupFilters();
    }
}

