/*
 * Decompiled with CFR 0.152.
 */
package jme3test.niftygui;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.post.SceneProcessor;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import java.net.URL;

public class TestNiftyGui
extends SimpleApplication
implements ScreenController {
    private Nifty nifty;

    public static void main(String[] args) {
        TestNiftyGui app = new TestNiftyGui();
        app.setPauseOnLostFocus(false);
        app.start();
    }

    public void simpleInitApp() {
        Box b = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        Geometry geom = new Geometry("Box", (Mesh)b);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", this.assetManager.loadTexture("Interface/Logo/Monkey.jpg"));
        geom.setMaterial(mat);
        this.rootNode.attachChild((Spatial)geom);
        NiftyJmeDisplay niftyDisplay = new NiftyJmeDisplay(this.assetManager, this.inputManager, this.audioRenderer, this.guiViewPort);
        this.nifty = niftyDisplay.getNifty();
        URL url = Thread.currentThread().getContextClassLoader().getResource("jme3test/niftygui/hellojme.xml");
        this.nifty.fromXml("Interface/Nifty/HelloJme.xml", "start", new ScreenController[]{this});
        this.guiViewPort.addProcessor((SceneProcessor)niftyDisplay);
        this.flyCam.setDragToRotate(true);
    }

    public void bind(Nifty nifty, Screen screen) {
        System.out.println("bind( " + screen.getScreenId() + ")");
    }

    public void onStartScreen() {
        System.out.println("onStartScreen");
    }

    public void onEndScreen() {
        System.out.println("onEndScreen");
    }

    public void quit() {
        this.nifty.gotoScreen("end");
    }
}

