/*
 * Decompiled with CFR 0.152.
 */
package jme3test.network.sync;

import com.jme3.app.SimpleApplication;
import com.jme3.effect.shapes.EmitterSphereShape;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.network.connection.Client;
import com.jme3.network.connection.Server;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.sync.ClientSyncService;
import com.jme3.network.sync.EntityFactory;
import com.jme3.network.sync.ServerSyncService;
import com.jme3.network.sync.SyncEntity;
import com.jme3.network.sync.SyncMessage;
import com.jme3.scene.Spatial;
import java.io.IOException;
import jme3test.network.sync.BoxEntity;
import jme3test.network.sync.ClientBoxEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSync
extends SimpleApplication
implements EntityFactory {
    private Client client;
    private ClientSyncService clientSyncServ;
    private Server server;
    private ServerSyncService serverSyncServ;
    private BoxEntity serverBox;
    private Vector3f targetPos = new Vector3f();
    private float boxSpeed = 3.0f;
    private EmitterSphereShape randomPosSphere = new EmitterSphereShape(Vector3f.ZERO, 5.0f);

    public static void main(String[] args) {
        TestSync app = new TestSync();
        app.start();
    }

    public void simpleInitApp() {
        Serializer.registerClass(SyncMessage.class);
        try {
            this.server = new Server(5110, 5110);
            this.server.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.serverSyncServ = (ServerSyncService)this.server.getService(ServerSyncService.class);
        this.serverBox = new BoxEntity(this.assetManager, ColorRGBA.Red);
        this.serverSyncServ.addNpc((SyncEntity)this.serverBox);
        this.rootNode.attachChild((Spatial)this.serverBox);
        this.serverSyncServ.setNetworkSimulationParams(0.1f, 200L);
        try {
            this.client = new Client("localhost", 5110, 5110);
            this.client.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.clientSyncServ = (ClientSyncService)this.client.getService(ClientSyncService.class);
        this.clientSyncServ.setEntityFactory((EntityFactory)this);
    }

    public SyncEntity createEntity(Class<? extends SyncEntity> entityType) {
        ClientBoxEntity clientBox = new ClientBoxEntity(this.assetManager, ColorRGBA.Green);
        this.rootNode.attachChild((Spatial)clientBox);
        return clientBox;
    }

    public void simpleUpdate(float tpf) {
        this.clientSyncServ.update(tpf);
        if (this.serverBox.getLocalTranslation().distance(this.targetPos) < 0.1f) {
            this.randomPosSphere.getRandomPoint(this.targetPos);
        } else {
            Vector3f velocity = new Vector3f(this.targetPos);
            velocity.subtractLocal(this.serverBox.getLocalTranslation());
            velocity.normalizeLocal().multLocal(this.boxSpeed);
            Vector3f newPos = this.serverBox.getLocalTranslation().clone();
            newPos.addLocal(velocity.mult(tpf));
            this.serverBox.setPosVel(newPos, velocity);
        }
        this.serverSyncServ.update(tpf);
    }

    public void destroy() {
        super.destroy();
        try {
            this.client.disconnect();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

