/*
 * Decompiled with CFR 0.152.
 */
package jme3test.network;

import com.jme3.network.AbstractMessage;
import com.jme3.network.Client;
import com.jme3.network.Message;
import com.jme3.network.MessageConnection;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.Serializer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestThroughput
implements MessageListener<MessageConnection> {
    private static long lastTime = -1L;
    private static long counter = 0L;
    private static long total = 0L;
    private static boolean testReliable = false;
    private boolean isOnServer;

    public TestThroughput(boolean isOnServer) {
        this.isOnServer = isOnServer;
    }

    public void messageReceived(MessageConnection source, Message msg) {
        if (!this.isOnServer) {
            ++counter;
            ++total;
            long time = System.currentTimeMillis();
            if (lastTime < 0L) {
                lastTime = time;
            } else if (time - lastTime > 1000L) {
                long delta = time - lastTime;
                double scale = (double)delta / 1000.0;
                double pps = (double)counter / scale;
                System.out.println("messages per second:" + pps + "  total messages:" + total);
                counter = 0L;
                lastTime = time;
            }
        } else if (source == null) {
            System.out.println("Received a message from a not fully connected source, msg:" + msg);
        } else {
            msg.setReliable(testReliable);
            source.send(msg);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Serializer.registerClass(TestMessage.class);
        Server server = Network.createServer((int)5110, (int)5110);
        server.start();
        Client client = Network.connectToServer((String)"localhost", (int)5110);
        client.start();
        client.addMessageListener((MessageListener)new TestThroughput(false), new Class[]{TestMessage.class});
        server.addMessageListener((MessageListener)new TestThroughput(true), new Class[]{TestMessage.class});
        Thread.sleep(1L);
        TestMessage test = new TestMessage();
        while (true) {
            client.send((Message)test);
        }
    }

    @Serializable
    public static class TestMessage
    extends AbstractMessage {
        public TestMessage() {
            this.setReliable(testReliable);
        }
    }
}

