/*
 * Decompiled with CFR 0.152.
 */
package jme3test.network;

import com.jme3.network.AbstractMessage;
import com.jme3.network.Client;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import com.jme3.network.Server;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSerialization
implements MessageListener<HostedConnection> {
    public void messageReceived(HostedConnection source, Message m) {
        TestSerializationMessage cm = (TestSerializationMessage)m;
        System.out.println(cm.z);
        System.out.println(cm.b);
        System.out.println(cm.c);
        System.out.println(cm.s);
        System.out.println(cm.i);
        System.out.println(cm.f);
        System.out.println(cm.l);
        System.out.println(cm.d);
        System.out.println(Arrays.toString(cm.ia));
        System.out.println(cm.ls);
        System.out.println(cm.mp);
        System.out.println((Object)cm.status1);
        System.out.println((Object)cm.status2);
        System.out.println(cm.date);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Serializer.registerClass(SomeObject.class);
        Serializer.registerClass(TestSerializationMessage.class);
        Server server = Network.createServer((int)5110);
        server.start();
        Client client = Network.connectToServer((String)"localhost", (int)5110);
        client.start();
        server.addMessageListener((MessageListener)new TestSerialization(), new Class[]{TestSerializationMessage.class});
        client.send((Message)new TestSerializationMessage(true));
        Thread.sleep(10000L);
    }

    @Serializable
    public static class TestSerializationMessage
    extends AbstractMessage {
        boolean z;
        byte b;
        char c;
        short s;
        int i;
        float f;
        long l;
        double d;
        int[] ia;
        List<Object> ls;
        Map<String, SomeObject> mp;
        Status status1;
        Status status2;
        Date date;

        public TestSerializationMessage() {
            super(true);
        }

        public TestSerializationMessage(boolean initIt) {
            super(true);
            if (initIt) {
                this.z = true;
                this.b = (byte)-88;
                this.c = (char)89;
                this.s = (short)9999;
                this.i = 123;
                this.f = -7.54E9f;
                this.l = 9438345072805034L;
                this.d = -8.54834914703E93;
                this.ia = new int[]{456, 678, 999};
                this.ls = new ArrayList<Object>();
                this.ls.add("hello");
                this.ls.add(new SomeObject(-22));
                this.mp = new HashMap<String, SomeObject>();
                this.mp.put("abc", new SomeObject(555));
                this.status1 = Status.High;
                this.status2 = Status.Middle;
                this.date = new Date(System.currentTimeMillis());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        High,
        Middle,
        Low;

    }

    @Serializable
    public static class SomeObject {
        private int val;

        public SomeObject() {
        }

        public SomeObject(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }

        public String toString() {
            return "SomeObject[val=" + this.val + "]";
        }
    }
}

